const useSubSub = true;
let dataProvider = {
    maxConnection: 0,
    maxTagID: 0,
    slice: {},
    standardQuestions: {},
    tags: [],
    connections: {},
    products: {}
  },
  dP = dataProvider,
  initDataProvider = function(data) {

    Object.assign(dataProvider, {
      maxConnection: 0,
      maxTagID: 0,
      slice: dataProvider.slice,
      standardQuestions: {},
      tags: [],
      connections: {},
      products: {}
    })
    dP = dataProvider;

    Object.assign(dP, data);

    let key;


    for(key in data.products){
      data.products[key] = new dP.Product.ctor(data.products[key])
    }



    Object.assign(dP, {
      componentsList: [],
      componentsListHashByProduct: {}
    });



    for(key in data.components){
      const cmp = data.components[key];
      cmp.tags = [];
      dP.componentsList.push(cmp);
      (dP.componentsListHashByProduct[cmp.id] || (dP.componentsListHashByProduct[cmp.id] = [])).push(cmp);
    }


    if(useSubSub){
      data.tags = [];
      data.connections = [];
      dP.tagsHash = {};

      Object.values( data.products ).forEach( function( item ){
        if(item.subcat){
          const tag = dP.Tag.getOrCreate( item.subcat );
          dP.Tag.connectToProduct( dP.Product.getByID( item.id ), tag );
        }
      } );

    }else{
      dP.tagsHash = data.tags.reduce( ( store, item ) => {
        dP.maxTagID = Math.max( dP.maxTagID, item.id );
        store[ item.id ] = item;
        return store
      }, {} );


      data.connections.forEach( ( connection ) => {
        dP.maxConnection = Math.max( dP.maxConnection, connection.cid );
        if( connection.type === 0 ){
          data.products[ connection.eid ].tags.push( connection.tag )
        }
      } );
    }
  };
