import './paginationSlider.scss';
import StandardCard from "../standardCard/StandardCard.jsx";
import ArrPrev from '/svg/arrow_active.svg';
import ArrNext from '/svg/arrow_active-back.svg';
import Eye from '/svg/eye.svg';

const PaginationSlider = D.declare('view.cmp.PaginationSlider', () => {
    return <div class="pagination-slider">
        <div className="pagination-slider__flag">
            <span>Просмотрена</span>
            <Eye width="20" height="13"/>
        </div>
        <ul className="pagination-slider__bullets">
            <li>
                <button className="pagination-slider__bullet pagination-slider__bullet--seen" type="button"></button>
            </li>
            <li>
                <button className="pagination-slider__bullet pagination-slider__bullet--seen" type="button"></button>
            </li>
            <li>
                <button className="pagination-slider__bullet pagination-slider__bullet--seen pagination-slider__bullet--current" type="button"></button>
            </li>
            <li>
                <button className="pagination-slider__bullet" type="button"></button>
            </li>
            <li>
                <button className="pagination-slider__bullet" type="button"></button>
            </li>
        </ul>
        <button className={D.cls(
            'button',
            'button--round',
            'pagination-slider__control',
            'pagination-slider__control--prev'
        )} type="button"
            aria-label="Показать предыдущую карточку">
            <ArrPrev width="14" height="12"/>
        </button>
        <button className={D.cls(
            'button',
            'button--round',
            'pagination-slider__control',
            'pagination-slider__control--next'
        )} type="button"
                aria-label="Показать следующую карточку">
            <ArrNext width="14" height="12"/>
        </button>
        <div className="pagination-slider__scroller">
            <div className="pagination-slider__wrapper">
                <div className="pagination-slider__item">
                    <StandardCard/>
                </div>
            </div>
        </div>
    </div>
})

export default PaginationSlider;
export {PaginationSlider};
