import '/model/Store';

import Header from '/view/block/header/Header.jsx';
import "/global-styles/base.scss";

import { Switch } from "./view/cmp/switch/Switch";
import {Page} from "./view/page/Page";
import '/controller/MainController';

export default function() {
  let tagField, exportEl;

  let dom = <div renderTo={document.body} cls="page-content">
    <Header/>
    {Switch({
        cls: 'page-content__inner',
        key: 'navigation.current',
        beforeSwitch: (val, old)=>{tmpStore.set('beforeNavigation', {from:old, to: val});},
        afterSwitch: (val, old)=>{tmpStore.set('afterNavigation', {from:old, to: val});}
      },
      Object.keys(Page).reduce((store, pageName)=>{
        store[pageName] = new Page[pageName]();
        return store;
      }, {})
    )}
  </div>;
  const w = window;
  let resizeFn;
  w.addEventListener('resize', Store.debounce(resizeFn = function() {
    tmpStore.set({
      isMobile: w.innerWidth < 1025,
      width: w.innerWidth
    });
  },1000/20));
  resizeFn();
  tmpStore.set('loaded', true);

};


