import './accountPage.scss';
import AccountBlock from '../../block/account/Account.jsx';
import {AsyncAuthAjax} from "../../../controller/Ajax";
import {API} from "../../../dict/Consts";
import Card from "../../cmp/card/Card";
import CardSlider from "../../cmp/cardSlider/CardSlider";
import AccountNavigation from "../../block/accountNav/AccountNavigation";

const Account = D.declare('view.page.Account', () => {
    let Slider = new CardSlider( {

        name: "newCardsSlider",

        itemClick: ( item, action ) => {
          action.execute( item );
        },


        items: _ => store.sub(
          [
            'loaded.cards',
            'navigation.current',
            tmpStore.bind( 'afterNavigation.to' ),
            tmpStore.bind( 'newCardsLoaded' ),
          ],
          function( loadedCards, to, newCardsLoaded ){
            if( newCardsLoaded !== loadedCards ){
              if( loadedCards && to === 'Account' ){
                _( cards
                  .getArray()
                  .filter( card => card.seen === false )
                  .sort( ( a, b ) => a.id - b.id )
                );

                tmpStore.set( 'newCardsLoaded', loadedCards )
              }
            }
          }
        )
      } );

    const dom = <div class="account-page">
        <h1 class="readers-only">Страница личного кабинета сотрудника</h1>
        <div class="account-page__wrapper">
            <div class="account-page__menu">
                <div class="account-page__menu-inner">
                    <AccountBlock />
                </div>
            </div>
            <div class="account-page__content">
                <div class="account-page__content-inner">
                    <div class="account-page__cards">
                        <h2 class="account-page__title">Новые карточки для вашей должности:</h2>
                      {Slider}
                        <div className="account-page__no-cards">
                            <div className="account-page__no-cards-info">
                                <div className="account-page__no-cards-item">
                                    <Card
                                        type={'product'}
                                        disabled
                                        title={'Карточек нет'}
                                        image={'/uploads/images/card-disabled.png'}
                                    />
                                </div>
                                <div className="account-page__no-cards-text">
                                    <p>Вы&nbsp;просмотрели все новые карточки этого месяца.</p>
                                    <p>Так держать!</p>
                                </div>
                            </div>
                            <div className="account-page__no-cards-image">
                                <picture>
                                    <source srcset="uploads/images/assistant-nocards-mob.svg" media={"(max-width: 767px"}/>
                                    <img src="uploads/images/assistant-nocards.svg" alt=""/>
                                </picture>
                            </div>
                        </div>
                        <div className="account-page__nav">
                            <AccountNavigation/>
                        </div>


                    </div>
                </div>
            </div>
        </div>
    </div>;

  tmpStore.valEqualOnly('afterNavigation.to', 'Account')(function() {
    Slider.restore();
  });
  tmpStore.valEqualOnly('beforeNavigation.from', 'Account')(function() {
    Slider.save();
  });

  return dom;
});

export default Account;
export {Account};
