import './infoCard.scss';
import Button from "../button/Button";
import ProductCard from '../productCard/ProductCard.jsx';
import Back from '/svg/arr-back.svg';
import Arr from '/svg/arr.svg';

const InfoCard = D.declare('view.cmp.InfoCard', (cfg) => {
    return <div class="info-card">
        <div className="info-card__header">
            <div className="info-card__headline">
                <h1 className="info-card__title">Печенье "Орешки"</h1>
                <p className="info-card__category">Категория Топ 35</p>
            </div>
            <div className="info-card__stats">
                <p>Карточек в категории: <b>20</b></p>
                <p>Просмотрено: <em>2</em></p>
            </div>
        </div>
        <div className="info-card__body">
            <ProductCard/>
        </div>
        <div className="info-card__footer">
            <Button class={"button info-card__link"}><Back width="17" height="11"/><span>Предыдущая карточка</span></Button>
            <Button class={"button info-card__link"}><span>Следующая карточка</span><Arr width="17" height="11"/></Button>
        </div>
    </div>
})

export default InfoCard;
export {InfoCard};
