const qB = {
  randomProduct: function({
                            minComponents,
                            amount,
                            single,
                            connectedByTags,
                            minSimilarTags
                          }, log) {
    let filtered = Object.values(dP.products);


    filtered = filtered
      .filter((p)=>p.getComponents().length >= minComponents);

    log.push(`Have >= ${minComponents} components: `+filtered.length);

    if(single){
      amount = 1;
    }

    let minAmount, maxAmount;

    if(typeof amount !== 'number'){
      minAmount = amount.from;
      maxAmount = amount.to;
    }else{
      minAmount = maxAmount = amount;
    }




    let similarClusters = [];
    if(connectedByTags){
      let tagsHash = {};
      filtered.forEach(p => {
        p.getTags().forEach(({id})=>
          (tagsHash[id] || (tagsHash[id] = [])).push(p)
        );
      });

      let similarTags = {};
      filtered.forEach(p => {
        const tags = p.getTags(),
              tagsStr = tags.map(({id})=>id).sort().join(',');
        if(tagsStr in similarTags)
          return;

        let similar = filtered
            .map(subP =>
              ({
                similar: subP.getTags().filter(subT => tags.indexOf(subT)>-1).length,
                p: subP
              })
            )
            .filter(i=>i.similar>0)
            .sort((a, b)=>b.similar - a.similar);

        if(similar.length){
          let maxCount = similar[ 0 ].similar;
          let minCount = minSimilarTags || Math.round( maxCount - maxCount / 4 );

          similarTags[ tagsStr ] = similar
            .filter( s => s.similar >= minCount )
            .map(s=>s.p)
        }

      });

      similarClusters = Object.values(similarTags)
        .filter( a => a.length >= minAmount);

      log.push('Similar clustered components by tags: '+similarClusters.title);

      filtered = rand(similarClusters);
    }


    let result;
    if(single){
      result = rand(filtered);
      log.push('Matched product: '+result.title);

    }else{
      if(filtered.length < minAmount){
        log.push(`Not enough components meeting criteria`);
        return false;
      }

      result = shuffle(filtered).slice(0, rand(minAmount, maxAmount));
      log.push('Base products:');
      result.forEach(p => log.push(`  > ${p.title}`))
      log.push('');
    }

    return result;
  },



  getComponents: function(product, ) {

  }
};