import './accountPage.scss';
import AccountBlock from '../../block/account/Account.jsx';
import {AsyncAuthAjax} from "../../../controller/Ajax";
import {API} from "../../../dict/Consts";
import Card from "../../cmp/card/Card";
import CardSlider from "../../cmp/cardSlider/CardSlider";
import AccountNavigation from "../../block/accountNav/AccountNavigation";
const {IF, ELSE} = Store;
const Account = D.declare('view.page.Account', () => {

  const showSlider = new Store.Value.Boolean(true);
  // subscribe to new cards
  store.sub(
    [
      'loaded.cards',
      tmpStore.bind( 'afterNavigation.to' ),
      tmpStore.bind( 'newCardsLoaded' ),
      tmpStore.bind( 'newItemCount' )
    ],
    function( loadedCards, to, newCardsLoaded, newItemCount ){

      let stamp = [loadedCards, newItemCount].join(';');
      if( newCardsLoaded !== stamp ){
        if( loadedCards && to === 'Account' ){
          const newCards = Model.cards
            .getArray()
            .filter( card => card.seen === false )
            .sort( ( a, b ) => a.id - b.id )
            .slice(0, newItemCount);

          // finally we get new cards!


          showSlider.set(newCards.length);
          Slider.setItems(newCards);


          tmpStore.set( 'newCardsLoaded', stamp )
        }
      }
    }
  );

    let Slider = new CardSlider( {

        name: "newCardsSlider",

        itemClick: ( item, action ) => {
          action.execute( item );
        }
      } );

    const dom = <div class="account-page">
        <h1 class="readers-only">Страница личного кабинета сотрудника</h1>
        <div class="account-page__wrapper">
            <div class="account-page__menu">
                <div class="account-page__menu-inner">
                    <AccountBlock />
                </div>
            </div>
            <div class="account-page__content">
                <div class="account-page__content-inner">
                    <div class="account-page__cards">
                      <h2 class="account-page__title">Новые карточки для вашей должности:</h2>
                      <IF condition={showSlider}>
                        {Slider}
                      <ELSE/>
                        <div className="account-page__no-cards">
                          <div className="account-page__no-cards-info">
                            <div className="account-page__no-cards-item">
                              <Card
                                type={'product'}
                                disabled
                                title={'Карточек нет'}
                                image={'/uploads/images/card-disabled.png'}
                              />
                            </div>
                            <div className="account-page__no-cards-text">
                              <p>Вы&nbsp;просмотрели все новые карточки этого месяца.</p>
                              <p>Так держать!</p>
                            </div>
                          </div>
                          <div className="account-page__no-cards-image">
                            <picture>
                              <source srcSet="uploads/images/assistant-nocards-mob.svg" media={"(max-width: 767px"}/>
                              <img src="uploads/images/assistant-nocards.svg" alt=""/>
                            </picture>
                          </div>
                        </div>
                      </IF>

                      <div className="account-page__nav">
                          <AccountNavigation/>
                      </div>


                    </div>
                </div>
            </div>
        </div>
    </div>;

  tmpStore.valEqualOnly('afterNavigation.to', 'Account')(function() {
    Slider.restore();
  });
  tmpStore.valEqualOnly('beforeNavigation.from', 'Account')(function() {
    Slider.save();
  });

  return dom;
});

export default Account;
export {Account};
