import './card.scss';
import Eye from '/svg/eye.svg';
import Button from "../button/Button";
import Format from "../format/Format";
import ACTION from "../../../controller/Action";
const noFn = ()=>{};
const Card = D.declare('view.cmp.Card', (cfg) => {
    const action = cfg.action || noFn;
    return <div className={D.cls('card card--'+
        (cfg.disabled?'disabled':
            cfg.seen?'seen':cfg.type))}>
        <div className="card__image">
            <img src={cfg.image} alt=""/>
        </div>
        <h3 className="card__title"><span><Format>{cfg.title}</Format></span></h3>
        <div className="card__footer">
            {cfg.disabled ? null:(
                cfg.seen ?
                    <div className="card__note">
                        <span>Просмотрена</span>
                        <Eye width="20" height="13"/>
                    </div>
                    :
                    <Button class={"button card__button"} onclick={()=>cfg.action(ACTION.CARD.LEARN_MORE)}>
                        <span>Изучить</span>
                    </Button>
            )
            }
        </div>
    </div>
})

export default Card;
export {Card};
