var catsHash = {};
var catsList = []

var cardsList = [];
var cardsHash = {};

module.exports = {
    '/api/category': {
        method: 'GET',
        summary: 'Get list of categories',
        options: {
            withCards: {required: false, description: 'attach cards', type: Boolean}
        },
        fn: async function(args){
            if(catsList.length === 0){
                catsList = await asyncPool('SELECT id, name, description,image,hidden, type from categories ORDER BY id desc;', []);
                for (var i = 0; i < catsList.length; i++) {
                    var catsListElement = catsList[i];
                    catsHash[catsListElement.id] = catsListElement;
                }
            }

            return catsList;
        }
    },
    '/api/cards': {
        method: 'GET',
        summary: 'Get list of categories',
        options: {
            withCards: {required: false, description: 'attach cards', type: Boolean}
        },
        fn: async function(args){
            if(cardsList.length === 0){
                cardsList = await asyncPool('SELECT id, category_id, name, text, image, type from cards ORDER BY id desc;', []);
                for (var i = 0; i < cardsList.length; i++) {
                    var card = cardsList[i];
                    cardsHash[card.id] = card;
                }
            }

            return cardsList;
        }
    }
};