const csv = require('csv-parser'),
      fs = require('fs'),
      path = require('path');

const readCSV = async function(scope) {
  const {fileName, types, keys, index} = scope,
    postProcess = scope.postProcess || (a => a);

  const trash = Symbol('Trash')
  const hash = {};
  return await new Promise(function(resolve, reject) {
    let id = 1;
    const inc = ()=>id++;

    fs.createReadStream(fileName)
      .pipe(csv({
        mapHeaders: ({header}) => keys[header] || trash,
        mapValues: ({header, value}) => header in types ? types[header](value) : null
      }))
      .on('data', (obj) => {
        if(postProcess(obj, inc)!==false)
          hash[obj[index]] = obj;
      })
      .on('end', () => {
        resolve(hash);
        console.log('CSV parsed: '+ fileName)
      });
  });
};
const base = process.env.KUS_DATA_DIR || './data';

//const connections = JSON.parse(fs.readFileSync(path.join(base,'connections.json'))+'');
//const tags = JSON.parse(fs.readFileSync(path.join(base,'tags.json'))+'');

data = {tags:[], connections:[], more:[], standardQuestions: {}, standardAnswers: {}};
(async()=>{
  /*data.components = await readCSV({
    fileName: path.join(base,'components.csv'),
    keys: {
      'номер карточки': 'id',
      'ингредиент': 'name'
    },
    types: {
      id: Number,
      name: String
    },
    postProcess: (a, inc) => a.iID = inc(),
    index: 'iID'
  });

  data.standardQuestions = await readCSV({
    fileName: path.join(base,'standard_questions.csv'),
    keys: {
      'id': 'qID',
      'card_info_id': 'cardInfoID',
      'text': 'title',
      'image': 'image',
      'type': 'multiple'
    },
    types: {
      qID: Number,
      cardInfoID: Number,
      title: String,
      image: String,
      multiple: String,
    },
    postProcess: (a) => {
      a.answers = [];
      a.multiple = a.multiple === 'checkbox';
      a.category = 2;
    },
    index: 'qID'
  });*/

  var maxQ = 1;
  /*const standardAnswers = await readCSV({
    fileName: path.join(base,'standard_answers.csv'),
    keys: {
      'question_id': 'qID',
      'text': 'title',
      'correct': 'correct',
    },
    types: {
      qID: Number,
      title: String,
      correct: Number
    },
    postProcess: (a, inc) => {
      a.id = inc();
      a.answers = [];
      a.correct = a.correct === 1;
    },
    index: 'id'
  });
  Object.values(standardAnswers).forEach(a=>{
    maxQ = Math.max(a.qID, maxQ);
    data.standardQuestions[a.qID].answers.push(a);
  });

  data.products = await readCSV({
    fileName: path.join(base,'products.csv'),
    keys: {
      '': 'id',
      'название': 'title',
      'описание': 'description',
      'категория': 'cat',
      'подкатегория': 'subcat',
      'подподкатегория': 'subsubcat',
      'участвует в тесте': 'use'
    },
    types: {
      id: Number,
      title: String,
      description: String,
      cat: String,
      subcat: String,
      subsubcat: String,
      use: a=>Boolean(Number(a))
    },
    index: 'id'
  });*/


  var dumped = [ {
    "id": 1,
    "title": "Блины \"Карбонара\"",
    "image": "/upload/resize/161031/161031_530x300x85_c.jpg"
  }, { "id": 2, "title": "Блины с начинкой жюльен", "image": "/upload/resize/93710/93710_530x300x85_c.jpg" }, {
    "id": 3,
    "title": "Блины с ветчиной (из свинины) и с сыром",
    "image": "/upload/resize/93352/93352_530x300x85_c.jpg"
  }, { "id": 4, "title": "Блины с мясом", "image": "/upload/resize/95146/95146_530x300x85_c.jpg" }, {
    "id": 5,
    "title": "Блины постные с картофелем и грибами",
    "image": "/upload/resize/96634/96634_530x300x85_c.jpg"
  }, { "id": 6, "title": "Варенье вишневое, 50 г" }, {
    "id": 7,
    "title": "Малина дроблёная с сахаром",
    "image": "/upload/resize/113263/113263_530x300x85_c.jpg"
  }, {
    "id": 8,
    "title": "Варенье из слив с лимоном и имбирем",
    "image": "/upload/resize/95818/95818_530x300x85_c.jpg"
  }, { "id": 9, "title": "Варенье черничное", "image": "/upload/resize/93853/93853_530x300x85_c.jpg" }, {
    "id": 10,
    "title": "Варенье из клубники с мятой",
    "image": "/upload/resize/94377/94377_530x300x85_c.jpg"
  }, { "id": 11, "title": "Голубцы ленивые в сметанном соусе" }, {
    "id": 12,
    "title": "Лингвини с креветками и с соусом с тыквой",
    "image": "/upload/resize/94017/94017_530x300x85_c.jpg"
  }, {
    "id": 13,
    "title": "Котлетки рыбные с запечёнными овощами",
    "image": "/upload/resize/157871/157871_530x300x85_c.jpg"
  }, {
    "id": 14,
    "title": "Паста с лососем в сливочном соусе",
    "image": "/upload/resize/162506/162506_530x300x85_c.jpg"
  }, {
    "id": 15,
    "title": "Голубцы с курицей в томатном соусе",
    "image": "/upload/resize/154668/154668_530x300x85_c.jpg"
  }, { "id": 16, "title": "Бейгл с кунжутом", "image": "/upload/resize/161019/161019_530x300x85_c.jpg" }, {
    "id": 17,
    "title": "Хлеб бородинский бездрожжевой",
    "image": "/upload/resize/113263/113263_530x300x85_c.jpg"
  }, { "id": 18, "title": "Чиабатта", "image": "/upload/resize/96735/96735_530x300x85_c.jpg" }, {
    "id": 19,
    "title": "Хлеб Печерский масличный",
    "image": "/upload/resize/94387/94387_530x300x85_c.jpg"
  }, { "id": 20, "title": "Слойка Свердловская", "image": "/upload/resize/157888/157888_530x300x85_c.jpg" }, {
    "id": 21,
    "title": "Мидии мясо варено-мороженное",
    "image": "/upload/resize/96601/96601_530x300x85_c.jpg"
  }, {
    "id": 22,
    "title": "Кальмар филе очищенный зам.",
    "image": "/upload/resize/93260/93260_530x300x85_c.jpg"
  }, {
    "id": 23,
    "title": "Креветка северная варено-мороженая",
    "image": "/upload/resize/95442/95442_530x300x85_c.jpg"
  }, { "id": 24, "title": "Кальмар кольца зам.", "image": "/upload/resize/93248/93248_530x300x85_c.jpg" }, {
    "id": 25,
    "title": "Кальмар тушка зам.",
    "image": "/upload/resize/158195/158195_530x300x85_c.jpg"
  }, {
    "id": 26,
    "title": "Шпинат свежезамороженный",
    "image": "/upload/resize/96005/96005_530x300x85_c.jpg"
  }, { "id": 27, "title": "Смесь Гавайская с/м", "image": "/upload/resize/95103/95103_530x300x85_c.jpg" }, {
    "id": 28,
    "title": "Смесь мексиканская с/м",
    "image": "/upload/resize/95101/95101_530x300x85_c.jpg"
  }, { "id": 29, "title": "Весенние овощи с/м", "image": "/upload/resize/95099/95099_530x300x85_c.jpg" }, {
    "id": 30,
    "title": "Смесь овощная для вок с/м",
    "image": "/upload/resize/157890/157890_530x300x85_c.jpg"
  }, {
    "id": 31,
    "title": "Колбаса «Сервелат Коньячный» в/к",
    "image": "/upload/resize/94937/94937_530x300x85_c.jpg"
  }, {
    "id": 32,
    "title": "Колбаса «Особенная» из индейки варёная",
    "image": "/upload/resize/93938/93938_530x300x85_c.jpg"
  }, {
    "id": 33,
    "title": "Колбаса запеченная из индейки",
    "image": "/upload/resize/93844/93844_530x300x85_c.jpg"
  }, {
    "id": 34,
    "title": "Колбаса «Брауншвейг. полусухая» с/к в/у",
    "image": "/upload/resize/95596/95596_530x300x85_c.jpg"
  }, { "id": 35, "title": "Колбаса кровяная с гречкой" }, {
    "id": 36,
    "title": "Шампунь Яичный",
    "image": "/upload/resize/95618/95618_530x300x85_c.jpg"
  }, { "id": 37, "title": "Шампунь мужской", "image": "/upload/resize/93625/93625_530x300x85_c.jpg" }, {
    "id": 38,
    "title": "Шампунь молочный Миндаль",
    "image": "/upload/resize/95620/95620_530x300x85_c.jpg"
  }, {
    "id": 39,
    "title": "Маска для волос Сладкий миндаль",
    "image": "/upload/resize/93749/93749_530x300x85_c.jpg"
  }, {
    "id": 40,
    "title": "Шампунь твёрдый \"Крапивный\"",
    "image": "/upload/resize/157311/157311_530x300x85_c.jpg"
  }, {
    "id": 41,
    "title": "Пастила фруктовая из персика",
    "image": "/upload/resize/153082/153082_530x300x85_c.jpg"
  }, {
    "id": 42,
    "title": "Пастила яблочная натуральная",
    "image": "/upload/resize/99730/99730_530x300x85_c.jpg"
  }, {
    "id": 43,
    "title": "Пастила яблочная хрустящая",
    "image": "/upload/resize/96081/96081_530x300x85_c.jpg"
  }, {
    "id": 44,
    "title": "Пастила яблоко-вишня хрустящая",
    "image": "/upload/resize/95513/95513_530x300x85_c.jpg"
  }, {
    "id": 45,
    "title": "Мармелад \"Облепиха\"",
    "image": "/upload/resize/162524/162524_530x300x85_c.jpg"
  }, { "id": 46, "title": "Булгур", "image": "/upload/resize/94357/94357_530x300x85_c.jpg" }, {
    "id": 47,
    "title": "Кускус",
    "image": "/upload/resize/96042/96042_530x300x85_c.jpg"
  }, { "id": 48, "title": "Киноа", "image": "/upload/resize/96046/96046_530x300x85_c.jpg" }, {
    "id": 49,
    "title": "Рис для плова Басмати экстрадлинный",
    "image": "/upload/resize/96040/96040_530x300x85_c.jpg"
  }, { "id": 50, "title": "Рис \"Жасмин\"", "image": "/upload/resize/157295/157295_530x300x85_c.jpg" }, {
    "id": 51,
    "title": "Йогурт греческий",
    "image": "/upload/resize/93247/93247_530x300x85_c.jpg"
  }, {
    "id": 52,
    "title": "Иммуноцея с сиропом шиповника",
    "image": "/upload/resize/93481/93481_530x300x85_c.jpg"
  }, { "id": 53, "title": "Мацони", "image": "/upload/resize/95610/95610_530x300x85_c.jpg" }, {
    "id": 54,
    "title": "Скир \"Исландский\" 1,5%",
    "image": "/upload/resize/162486/162486_530x300x85_c.jpg"
  }, { "id": 55, "title": "Творог 5%, 180 г", "image": "/upload/resize/162528/162528_530x300x85_c.jpg" }, {
    "id": 56,
    "title": "Балык «Королевский» с/к",
    "image": "/upload/resize/94876/94876_530x300x85_c.jpg"
  }, {
    "id": 57,
    "title": "Карпаччо из индейки с/к",
    "image": "/upload/resize/96643/96643_530x300x85_c.jpg"
  }, {
    "id": 58,
    "title": "Шпек сыровяленый нарезка, 50 г",
    "image": "/upload/resize/94257/94257_530x300x85_c.jpg"
  }, {
    "id": 59,
    "title": "Филе грудки индейки \"Су-вид\" в маринаде Корридо",
    "image": "/upload/resize/161126/161126_530x300x85_c.jpg"
  }, {
    "id": 60,
    "title": "Ребрышки говяжьи, 400 г",
    "image": "/upload/resize/151246/151246_530x300x85_c.jpg"
  }, { "id": 61, "title": "Вырезка из свинины", "image": "/upload/resize/93373/93373_530x300x85_c.jpg" }, {
    "id": 62,
    "title": "Половина тушки кролика",
    "image": "/upload/resize/36233/36233_530x300x85_c.jpg"
  }, { "id": 63, "title": "Стейк из индейки", "image": "/upload/resize/94623/94623_530x300x85_c.jpg" }, {
    "id": 64,
    "title": "Филе бедра куриное бескостное",
    "image": "/upload/resize/93376/93376_530x300x85_c.jpg"
  }, { "id": 65, "title": "Напиток Чай с лимоном", "image": "/upload/resize/94097/94097_530x300x85_c.jpg" }, {
    "id": 66,
    "title": "Напиток «Чайный гриб» со стевией",
    "image": "/upload/resize/94756/94756_530x300x85_c.jpg"
  }, {
    "id": 67,
    "title": "Напиток «Лимон-Имбирь»",
    "image": "/upload/resize/93810/93810_530x300x85_c.jpg"
  }, {
    "id": 68,
    "title": "Вода минеральная Псыж 1л",
    "image": "/upload/resize/141107/141107_530x300x85_c.jpg"
  }, {
    "id": 69,
    "title": "Напиток \"Кокосовый\" на бактериальной закваске",
    "image": "/upload/resize/155586/155586_530x300x85_c.jpg"
  }, {
    "id": 70,
    "title": "Паштет мясной запеченный",
    "image": "/upload/resize/94249/94249_530x300x85_c.jpg"
  }, {
    "id": 71,
    "title": "Паштет из тофу «По-испански»",
    "image": "/upload/resize/95069/95069_530x300x85_c.jpg"
  }, {
    "id": 72,
    "title": "Риет из горбуши с миндалем",
    "image": "/upload/resize/157319/157319_530x300x85_c.jpg"
  }, {
    "id": 73,
    "title": "Паштет мясной с печенью индейки и грушей",
    "image": "/upload/resize/96449/96449_530x300x85_c.jpg"
  }, {
    "id": 74,
    "title": "Паштет из печени кролика с шампиньонами",
    "image": "/upload/resize/157301/157301_530x300x85_c.jpg"
  }, { "id": 75, "title": "Суп Харчо", "image": "/upload/resize/36472/36472_530x300x85_c.jpg" }, {
    "id": 76,
    "title": "Борщ вегетарианский",
    "image": "/upload/resize/95379/95379_530x300x85_c.jpg"
  }, {
    "id": 77,
    "title": "Суп куриный с домашней лапшой",
    "image": "/upload/resize/93384/93384_530x300x85_c.jpg"
  }, {
    "id": 78,
    "title": "Суп-пюре норвежский с сёмгой",
    "image": "/upload/resize/154670/154670_530x300x85_c.jpg"
  }, {
    "id": 79,
    "title": "Уха русская с сёмгой",
    "image": "/upload/resize/151259/151259_530x300x85_c.jpg"
  }, {
    "id": 80,
    "title": "Ассорти из омуля, муксуна, чира",
    "image": "/upload/resize/161017/161017_530x300x85_c.jpg"
  }, {
    "id": 81,
    "title": "Ассорти рыбное х/к из скумбрии и горбуши",
    "image": "/upload/resize/157291/157291_530x300x85_c.jpg"
  }, {
    "id": 82,
    "title": "Ассорти рыбное х/к ломтики",
    "image": "/upload/resize/93193/93193_530x300x85_c.jpg"
  }, {
    "id": 83,
    "title": "Корюшка горячего копчения",
    "image": "/upload/resize/94935/94935_530x300x85_c.jpg"
  }, {
    "id": 84,
    "title": "Муксун ломтики холодного копчения",
    "image": "/upload/resize/96307/96307_530x300x85_c.jpg"
  }, {
    "id": 85,
    "title": "Салат с яблоком, свеклой и черносливом",
    "image": "/upload/resize/149089/149089_530x300x85_c.jpg"
  }, { "id": 86, "title": "Салат Мимоза", "image": "/upload/resize/96318/96318_530x300x85_c.jpg" }, {
    "id": 87,
    "title": "Салат «Грин Энерджи»",
    "image": "/upload/resize/95216/95216_530x300x85_c.jpg"
  }, { "id": 88, "title": "Салат «Оливье»", "image": "/upload/resize/93367/93367_530x300x85_c.jpg" }, {
    "id": 89,
    "title": "Салат винегрет с маринованной капустой",
    "image": "/upload/resize/95948/95948_530x300x85_c.jpg"
  }, {
    "id": 90,
    "title": "Сыр \"Российский\" тёртый",
    "image": "/upload/resize/162484/162484_530x300x85_c.jpg"
  }, {
    "id": 91,
    "title": "Сыр козий \"Кремчиз с брусникой и яблоком\"",
    "image": "/upload/resize/154664/154664_530x300x85_c.jpg"
  }, {
    "id": 92,
    "title": "Сыр твердый «Грюнбергер»",
    "image": "/upload/resize/93323/93323_530x300x85_c.jpg"
  }, { "id": 93, "title": "Сыр «Эдам»", "image": "/upload/resize/96491/96491_530x300x85_c.jpg" }, {
    "id": 94,
    "title": "Сыр «Алтайский» полутвёрдый",
    "image": "/upload/resize/96247/96247_530x300x85_c.jpg"
  }, {
    "id": 95,
    "title": "Тетрадь в линейку, 48 л",
    "image": "/upload/resize/157293/157293_530x300x85_c.jpg"
  }, {
    "id": 96,
    "title": "Десерт молочный \"Ночь в Брюгге\"",
    "image": "/upload/resize/156148/156148_530x300x85_c.jpg"
  }, {
    "id": 97,
    "title": "Панна-котта «Манго-маракуйя-апельсин»",
    "image": "/upload/resize/96593/96593_530x300x85_c.jpg"
  }, {
    "id": 98,
    "title": "Пирожное постное «Трюфельное»",
    "image": "/upload/resize/96391/96391_530x300x85_c.jpg"
  }, { "id": 99, "title": "Рулет бисквитный", "image": "/upload/resize/94957/94957_530x300x85_c.jpg" }, {
    "id": 100,
    "title": "Пирожное \"Малиновое\" на кокосовом молоке",
    "image": "/upload/resize/157898/157898_530x300x85_c.jpg"
  }, { "id": 101, "title": "Мята душистая", "image": "/upload/resize/143429/143429_530x300x85_c.jpg" }, {
    "id": 102,
    "title": "Горный чабрец",
    "image": "/upload/resize/95864/95864_530x300x85_c.jpg"
  }, {
    "id": 103,
    "title": "Чай с мятой и календулой в пакетиках",
    "image": "/upload/resize/94555/94555_530x300x85_c.jpg"
  }, {
    "id": 104,
    "title": "Чай зеленый байховый в пакетиках",
    "image": "/upload/resize/95751/95751_530x300x85_c.jpg"
  }, { "id": 105, "title": "Чай гречишный, в пирамидках" } ];
  let dumpedHash = {};
  let normalizeText = function(text) {
    return text.trim().toLowerCase().replace(/[^а-я]/g,'').replace(/[аоуеэюёиыя]+/g,'о')
  };
  dumped.forEach(d=>{
    dumpedHash[normalizeText(d.title)] = d;
  });
  //dumped.filter(a=>a.image).forEach(a=>data.products[a.id].image = 'https://vkusvill.ru'+a.image)
  //fs.writeFileSync('tmp.json',JSON.stringify(Object.values(data.products).map(({id, title})=>({id, title}))));

  data.more = data.more || [];
  var tid = 1, cid = 1;
  var tagsHash = {};
  data.more = data.more.concat([
    {p: '1cards_2020_02_28.csv',     i: '1components.csv'},
    {q: '2questions.csv', a: '2answers.csv', c: '2cards_2020_2_21.csv'},
    {q: '3questions.csv', a: '3answers.csv', c: '3cards.csv'},
    {q: '4questions.csv', a: '4answers.csv', c: '4cards.csv'}
  ]);
  let id = 1;
  let theInc = ()=>id++;
  let was = {};
  if(data.more){
    for( let i = 0, _i = data.more.length; i < _i; i++ ){
      var adishen = i*300;

      const moreElement = data.more[ i ];
      if( moreElement.p ){
        data.products = await readCSV({
          fileName: path.join(base, moreElement.p),
          keys: {
            '': 'id',
            'название': 'title',
            'описание': 'description',
            'Категория': 'category_id',
            'подкатегория': 'subcat',
            'подподкатегория': 'subsubcat',
            'участвует в тесте': 'use',
            'Картинка': 'image'
          },
          types: {
            id: Number,
            title: String,
            description: String,
            category_id: String,
            subcat: String,
            subsubcat: String,
            image: String,
            use: String
          },
          postProcess: ( a ) => {
            if( a.title.trim() === '' ) return false;
            a.use = ( a.use + '' )[ 0 ].toLowerCase() in { 'д': 1, '1': 1, 'y': '1', 'c': '1' };
            a.type = 1;
            id = Math.max(id, a.id);
            a.id = adishen+a.id;
            a.category_id = a.category_id |0;
            let h = dumpedHash[normalizeText(a.title)]
            if(h)
              a.image = h.image;
            a.items = [];
           /* var norm = normalizeText(a.subcat);
            if(!norm)
              debugger
            if(!(norm in tagsHash)){
              console.log(norm, a.subcat)
              data.tags.push(tagsHash[norm] = {id: tid++, name: a.subcat})
            }
            data.connections.push({
              cid: cid++,
              type: 0,
              eid: a.id,
              tag: tagsHash[norm].id
            });*/

          },
          index: 'id'
        });

        theInc();
        data.components = await readCSV({
          fileName: path.join(base, moreElement.i),
          keys: {
            'номер карточки': 'id',
            'ингредиент': 'name'
          },
          types: {
            id: Number,
            name: String
          },
          postProcess: (a, inc) => {
            a.iID = inc()
            a.id = adishen+a.id;
            if(a.id in data.products){
              data.products[ a.id ].items.push( a );
            }
          },

          index: 'iID'
        });
      }
      if( moreElement.c ){
        await readCSV({
          fileName: path.join(base,moreElement.c),
          keys: {
            'номер карточки': 'id',
            'Текст карточки': 'description',
            'Картинка': 'image',
            'Название': 'title'
          },
          types: {
            id: Number,
            title: String,
            description: String,
            category_id: String,
            image: String
          },
          postProcess: ( a, inc ) => {

            if( a.description.trim() === '' ) return false;
            a.id = adishen+a.id;

            a.use = ( a.use + '' )[ 0 ].toLowerCase() in { 'д': 1, '1': 1, 'y': '1', 'c': '1' };
            a.type = 2;
            a.category_id = moreElement.c[0]|0;
            a.iID = theInc();
            a.items = [{
              description: a.description,
              image: a.image
            }];
            //debugger

            if(a.id in was){
              was[a.id].items.push(a.items[0]);
            }else{
              was[a.id] = a;
              data.products[ a.iID ] = a;
            }
          },
          index: 'id'
        })
      }
      if( moreElement.q ){
        const Q = await readCSV( {
          fileName: path.join( base, moreElement.q ),
          keys: {
            'номер вопроса': 'qID',
            'карточка': 'cardInfoID',
            'Заголовок': 'title',
            'Тип вопроса': 'image',
            'множественный выбор': 'multiple',
            'Тип ответа': 'answer_type',
            '\\': 'category'
          },
          types: {
            qID: Number,
            cardInfoID: Number,
            title: String,
            image: String,
            multiple: String,
            category: Number,
            answer_type: String
          },
          postProcess: ( a ) => {
            if( a.title.trim() === '' ) return false;
            a.cardInfoID = adishen+a.cardInfoID;
            a.qID = adishen+a.qID;

            a.category_id = moreElement.q[0]|0;
            a.answers = [];
            a.multiple = ( a.multiple + '' )[ 0 ].toLowerCase() in { 'д': 1, '1': 1, 'y': '1', 'c': '1' };
            a.image = null;
          },
          index: 'qID'
        } );

        const A = await readCSV( {
          fileName: path.join( base, moreElement.a ),
          keys: {
            'номер вопроса': 'qID',
            'ответ': 'title',
            'правильный': 'correct',
          },
          types: {
            qID: Number,
            title: String,
            correct: String
          },
          postProcess: ( a, inc ) => {
            if( a.title.trim() === '' ) return false;
            a.id = inc();
            a.qID += adishen
            a.correct = ( a.correct + '' )[ 0 ].toLowerCase() in { 'д': 1, '1': 1, 'y': '1', 'c': '1' };
          },
          index: 'id'
        } );
        Object.values( A ).forEach( a => {
          Q[ a.qID ].answers.push( a );
        } );
        for( var qI in Q ){
          let id = ++maxQ;
          Q[ qI ].qID = id;
          Q[ qI ].answers.forEach( a => a.qID = id );
          data.standardQuestions[ id ] = Q[ qI ];
        }
      }
    }
  }


  //git add .
  // fs.writeFileSync('./data/tmp/full.json', JSON.stringify(data, null, 2))
  data.after && data.after(data);
})();


const keys = {
  'номер карточки': 'id',
  'ингредиент': 'name'
};
const mapper = {
  id: Number,
  name: String
};

module.exports = data;