import '../../cmp/field/LabeledField.jsx';
import Button from '../../cmp/button/Button.jsx';
import Logo from '../../../svg/logo_vkusvill.svg';
import './loginPage.scss';
import Arr  from '../../../svg/arr.svg';

import LoginHelp from './LoginHelp.jsx';
import LoginPhone from './LoginPhone.jsx';
import LoginCode from './LoginCode.jsx';

const {AND, OR, IF} = Store;
export default D.declare('view.page.Login', () => {
    const loginStore = new Store({
        phone: '79991112233',
        code: '',
        codeValid: false,
        active: 'enterPhone',
        phoneValid: false,
        phoneChecking: false,
        phoneError: false,
        phoneErrorText: '',
        incorrectPhone: false,
        displayHelpPage: false,
        codeError: false
    });



    return <div className={"login-page"}>
        <div class="login-page__big-logo">
            <Logo width="660" height="300"/>
        </div>

        <IF condition={loginStore.valTrue('displayHelpPage')}>
            <LoginHelp loginStore={loginStore}/>
        </IF>

        <IF condition={loginStore.valFalse('displayHelpPage')}>
            <h1 className="login-page__title">Добро пожаловать в&nbsp;развивающую платформу Вкусвилл!</h1>
            <form action="#" method="post" className="authorization-form">
                <Switch store={loginStore} key='active' content={{
                    enterPhone: <LoginPhone loginStore={loginStore}/>,
                    enterCode: <LoginCode loginStore={loginStore}/>
                }}/>
                <Button onClick={() => loginStore.set('displayHelpPage', true)} type={"button"}>Проблемы с авторизацией?</Button>
            </form>
        </IF>
    </div>
})
