view.cmp.Answer = function(answer, type) {
  return D.label({cls: D.cls('quiz-answer-label', 'quiz-answer-label__'+type)},
    D.input({
      attr: {type, checked: answer.correct}
    }),
    answer.text
  )

};

view.page.Generate = function() {
  const update = function() {
    const photo = store.get('generatePhoto') === 'photo',
      type = store.get('generateType'),
      category = store.get('generateCategory');

      try{
        seedInput.value = Math.random.seeded.getStringSeed();

        const result = category === 'product' ? quizGenerator( type, photo ) : standardGenerator(({length})=>rand(0,length-1));

        title.innerHTML = textFormat( result.question, true );
        image.innerHTML = result.image ? `<img src="${result.image}" alt="img"/>` : '';
        image.style.display = result.image ? 'block': 'none';
        debug.value = result.log.join( '\n' )
        D.removeChildren( answers );
        D.appendChild( answers, result.answers.map( ( a ) => view.cmp.Answer( a, type ) ) );
      }catch( e ){
        debug.value = quizGenerator.log.join( '\n' )
        console.error(e)
      }
  };

  let title, answers, debug, seedInput, image;

  this.dom =
    div({cls: 'generate-panel'},
      div({cls: 'title-gradient'},

        div({cls: 'generate-sub-menu'},

          div({cls: 'generate-sub-menu'},
            view.cmp.Menu({title: 'Продукты', id: 'product', key: 'generateCategory'}),
            view.cmp.Menu({title: 'Стандарты', id: 'standard', key: 'generateCategory'})
          ),
          view.cmp.Switch({key: 'generateCategory'}, {
            product: div({cls: 'generate-sub-menu'},
              div({cls: 'generate-sub-menu'},
                view.cmp.Menu({title: 'Единственный', id: 'radio', key: 'generateType'}),
                view.cmp.Menu({title: 'Множественный', id: 'checkbox', key: 'generateType'})
              ),

              div({cls: 'generate-sub-menu'},
                view.cmp.Menu({title: 'С фото', id: 'photo', key: 'generatePhoto'}),
                view.cmp.Menu({title: 'Без фото', id: 'noPhoto', key: 'generatePhoto'})
              )
            )
          })


        )
      ),
      div({cls: 'generate-controls'},
        D.input({
          attr: {type: 'button', value: 'F5'},
          on: {click: update}}),

        span({cls: 'generate-seed-label'}, 'Seed:'),
        seedInput = D.input({
          cls: 'seed',
          attr: {type: 'input', value: '', placeholder: 'seed'},
          on: {input: function() {
            var val = seedInput.value
            Math.random.seeded.setStringSeed(val);
            update()
            //Math.random.seeded.setStringSeed(val);
          }}}),

      ),

      div({cls: 'generate-example'},
        title = div({cls: 'generate-title'}),
        image = div({cls: 'generate-image'}),
        answers = div({cls: 'generate-answers'}),
        debug = D.textarea({cls: 'generate-debug'})
      )


    );

  store.sub(['generateType', 'generatePhoto', 'generateCategory'], update);

};