export const Ajax = {
  post(url: string, data: any, cb: Function){
    let stringData='';
    try{
      stringData = JSON.stringify(data);
      const xhr = new XMLHttpRequest();
      xhr.open("POST", url, true);
      xhr.setRequestHeader("Content-Type", "application/json");
      xhr.onreadystatechange = function () {
        if (xhr.readyState === 4 && xhr.status === 200) {
          let json;
          try {
            json = JSON.parse(xhr.responseText);
            cb && cb(false, json);
          }catch (e) {
            console.error('AJAX:POST Incorrect Response ← '+url, xhr.responseText, e);
            cb && cb(true, e);
          }
        }else if(xhr.status === 404){
          cb && cb(true);
        }else if(xhr.status === 401){
          //Пользователь не авторизован
          window.location.href = "/login";
          return;
        }else if(xhr.status === 403){
          //Нет доступа к ассистенту
          window.location.href = "/";
          return;
        }else if (xhr.status >= 400){
          /*HeaderModel.statusNotification.statuses.push({type: 'error'});
          setTimeout(function () {
            HeaderModel.statusNotification.statuses.length = 0;
          }, 3000);*/
          cb && cb(true, {"status":"error"});
          return;
        }
      };
      xhr.send(stringData);
    }catch (e) {
     /* HeaderModel.statusNotification.statuses.push({type: 'error'});
      setTimeout(function () {
        HeaderModel.statusNotification.statuses.length = 0;
      }, 3000);*/
      console.error('AJAX:POST → '+url, e);
      cb && cb(true, e);
    }
  },

  get(url: string, cb: Function){
    try{
      const xhr = new XMLHttpRequest();
      xhr.open("GET", url, true);
      xhr.setRequestHeader("Content-Type", "application/json");
      xhr.onreadystatechange = function () {
        if (xhr.readyState === 4 && xhr.status === 200) {
          let json;
          try {
            json = JSON.parse(xhr.responseText);
            cb && cb(false, json);
          }catch (e) {
            console.error('AJAX:GET Incorrect Response ← '+url, xhr.responseText, e);
            cb && cb(true, e);
          }
        }else if(xhr.status === 404){
          cb && cb(true);
        }else if(xhr.status === 401){
          //Пользователь не авторизован
          window.location.href = "/login";
          return;
        }else if(xhr.status === 403){
          //Нет доступа к ассистенту
          window.location.href = "/";
          return;
        } else if (xhr.status >= 400){
          /*HeaderModel.statusNotification.statuses.push({type: 'error'});
          setTimeout(function () {
            HeaderModel.statusNotification.statuses.length = 0;
          }, 3000);*/
          cb && cb(true, {"status":"error"});
        }
      };
      xhr.send(null);
    }catch (e) {
      /*HeaderModel.statusNotification.statuses.push({type: 'error'});
      setTimeout(function () {
        HeaderModel.statusNotification.statuses.length = 0;
      }, 3000);*/
      console.error('AJAX:GET → '+url, e);
      cb && cb(true, e);
    }
  }
};
export const AsyncAjax = {
  get(url: string) {
    return new Promise(function(resolve, reject) {
      Ajax.get(url, function(err, data) {
        if(err){
          reject(data);
        }else{
          resolve(data);
        }
      })
    });
  },
  post(url: string, data: any){

  }
};