view.cmp.Answer = function(answer, type) {
  return D.label({cls: D.cls('quiz-answer-label', 'quiz-answer-label__'+type)},
    D.input({
      attr: {type, checked: answer.correct}
    }),
    answer.text
  )

};

view.page.Generate = function() {
  const update = function() {
    const photo = store.get('generatePhoto') === 'photo',
      type = store.get('generateType'),

      result = quizGenerator(type, photo);

    title.innerText = result.question;
    debug.value = result.log.join('\n')
    D.removeChildren(answers);
    D.appendChild(answers, result.answers.map((a)=>view.cmp.Answer(a, type)));

  };

  let title, answers, debug;
  this.dom =
    div({cls: 'generate-panel'},
      div({cls: 'title-gradient'},
        div({cls: 'generate-sub-menu'},
          div({cls: 'generate-sub-menu'},
            view.cmp.Menu({title: 'Единственный', id: 'radio', key: 'generateType'}),
            view.cmp.Menu({title: 'Множественный', id: 'checkbox', key: 'generateType'})
          ),

          div({cls: 'generate-sub-menu'},
            view.cmp.Menu({title: 'С фото', id: 'photo', key: 'generatePhoto'}),
            view.cmp.Menu({title: 'Без фото', id: 'noPhoto', key: 'generatePhoto'})
          )
        )
      ),
      div({cls: 'generate-controls'},
        D.input({
          attr: {type: 'button', value: 'Refresh'},
          on: {click: update}})),

      div({cls: 'generate-example'},
        title = div({cls: 'generate-title'}),
        answers = div({cls: 'generate-answers'}),
        debug = D.textarea({cls: 'generate-debug'})
      )
    );

  store.sub(['generateType', 'generatePhoto'], update);

};