import './Switch.scss';
const Switch = D.declare('Switch', (cfg, contentHash) => {
  if(cfg.content){
    contentHash = cfg.content;
  }
  if(Array.isArray(contentHash)){
    if(contentHash.length === 0){
      if(cfg.content)
        contentHash = cfg.content;
    }else{
      contentHash = contentHash.reduce( function( store, { id, children } ){
        store[ id ] = children;
        return store;
      }, {} );
    }
  }

  const cmp = div( {
    cls: update => (cfg.store || store).sub(
      cfg.key,
        val => update(
          D.cls(
            'cmp-switch',
            cfg.cls,
            { 'cmp-switch__filled': val in contentHash } ) ) ) } );

  (cfg.store || store).sub( cfg.key, (val)=> {
    D.removeChildren(cmp);
    if(val in contentHash)
      D.appendChild( cmp, contentHash[ val ] );

  });

  return cmp;
});

Switch.Item = function(cfg, children) {
  if(!(this instanceof Switch.Item)){
    return new Switch.Item(cfg, children);
  }
  this.id = cfg.id;
  this.children = children;
};


export const Item = Switch.Item;
export default Switch;