;(function(Path){
  'use strict';


  var log = console.log;
  /*var log = function() {
    console.log.apply(console, ['Define'].concat([].slice.call(arguments)));
  };*/

  var head = document.getElementsByTagName( 'head' )[ 0 ];
  var cssLoader = function( fileName ){
    var link = document.createElement( 'link' );
    link.setAttribute( 'rel', 'stylesheet' );
    link.setAttribute( 'type', 'text/css' );
    link.setAttribute( 'href', fileName );
    head.appendChild( link );
    return true;
  };
  var jsLoader = function( fileName ){

    var script = document.createElement( 'script' );
    script.setAttribute( 'type', script.type = 'text/javascript' );
    script.onload = function(){

    };
    script.setAttribute( 'src', script.src = fileName );
    head.appendChild( script );
  };

  var InstantLoaders = [
    { name: '.scss', loader: cssLoader },
    { name: '.css', loader: cssLoader },
    { name: '.jsx', loader: jsLoader },
    { name: '.js', loader: jsLoader },
  ];

  var definitions = {};
  var waiting = {};

  var resolve = function(base, file) {
    return Path.resolve(Path.dirname(base), file);
  };
  var _define = function(name) {
    var definition = definitions[name];
    if(definition.notResolved === 0){
      console.log(name,'execute')
      definition.fn.apply(null, definition.deps.map(function(dep) {
        return dep === 'exports' ? definition.exports : definitions[dep].exports
      }));

      (waiting[definition.fileName] || []).forEach(function(name) {
        definitions[name].notResolved--;
        _define(name)
      });
    }
  };
  window.define = function(fileName, deps, fn) {
    fileName = Path.trim(fileName);
    deps = deps.map(function(dep) {
      return dep === 'exports' ? 'exports': resolve(fileName, dep);
    });

    definitions[fileName] = {fileName:fileName, deps: deps, fn:fn, exports: {}};
    var notResolved = 0;
    for( var i = 0, _i = deps.length; i < _i; i++ ){
      const dep = deps[ i ];
      if(dep === 'exports')
        continue;
      var skip = false;
      if(!(dep in definitions)){
        for( var j = 0, _j = InstantLoaders.length; j < _j; j++ ){
          const instantLoader = InstantLoaders[ j ];
          if(dep.substr(-instantLoader.name.length).toLowerCase()===instantLoader.name){
            if(!(dep in definitions)){
              if( instantLoader.loader( dep ) ){
                definitions[dep] = {exports: {}}
                skip = true;
              }
            }
            break;
          }
        }

      }else{
        skip = definitions[dep].notResolved === 0;
      }
      if(!skip){
        ( waiting[ dep ] || ( waiting[ dep ] = [] ) ).push( fileName );
        notResolved++;
      }
    }
    definitions[fileName].notResolved = notResolved;
    _define(fileName)
  };
  window.define.definitions = definitions;
  window.define.waiting = waiting;

})(window.__Path);