import './paginationSlider.scss';
import StandardCard from "../standardCard/StandardCard.jsx";
import ArrPrev from '/svg/arrow_active.svg';
import ArrNext from '/svg/arrow_active-back.svg';
import Eye from '/svg/eye.svg';
import CardSlider from "../cardSlider/CardSlider";
const {IF} = Store;
// Let it be singleton

const PaginationSliderSingleton = function(){
    this.store = new Store({
        seen: false
    });

    let Slider = new CardSlider( {
        name: "standardSlider",
        tpl: StandardCard,
        preset: {
            cardWidth: 290,
            minPadding: 10,
            mobilePadding: 10,
            desktopPadding: 30,
        },
        cls: 'standard-slider'

    } );

    const _self = this;
    this.backHidden = new Store.Value.Boolean(true);
    this.forwardHidden =  new Store.Value.Boolean(true);
    this.dom = <div className="pagination-slider">
        <IF condition={this.store.valEqual('seen', false)}>
            <div className="pagination-slider__flag">
                <span>Просмотрена</span>
                <Eye width="20" height="13"/>
            </div>
        </IF>
        <ul className="pagination-slider__bullets">
            {(update)=>{
                this.store.sub('items', function(items) {
                    Slider.setItems(items || []);

                    update((items || []).map((item, n)=>
                      <li>
                          <button class={D.cls('pagination-slider__bullet', {
                              'pagination-slider__bullet--seen': item.seen,
                              'pagination-slider__bullet--current': n === _self.current
                          })} type="button"/>
                      </li>
                    ))
                });
            }}
        </ul>
        {Slider}
        {/*<button className={D.cls(
          'button',
          'button--round',
          'pagination-slider__control',
          'pagination-slider__control--prev',
          {'pagination-slider__control-hidden': this.backHidden}

        )} type="button"
                aria-label="Показать предыдущую карточку">
            <ArrPrev width="14" height="12"/>
        </button>
        <button className={D.cls(
          'button',
          'button--round',
          'pagination-slider__control',
          'pagination-slider__control--next',
          {'pagination-slider__control-hidden': this.forwardHidden}
        )} type="button"
                aria-label="Показать следующую карточку">
            <ArrNext width="14" height="12"/>
        </button>
        <div className="pagination-slider__scroller">
            <div className="pagination-slider__wrapper">
                <div className="pagination-slider__item">
                    <StandardCard item={this.store}/>
                </div>
            </div>
        </div>*/}
    </div>;
};
PaginationSliderSingleton.prototype = {
    current: 0,
    apply: function({item, category}) {
        this.current = 0;
        this.store.reSet(item);

        return this;
    }
};
let instance;
const PaginationSlider = D.declare('view.cmp.PaginationSlider', (cfg) => {
    return (instance || (instance = new PaginationSliderSingleton)).apply(cfg).dom;
});

export default PaginationSlider;
export {PaginationSlider};
