import Button from "/view/cmp/button/Button.jsx";
import { AsyncAjax } from "/core/Ajax.jsx";
import { API } from "/dict/Consts.jsx";
import Arr  from '/svg/arr.svg';

const {AND, OR, IF} = Store;
export default D.declare('view.page.LoginPhone', ({loginStore}) => {

  const checkPhone = async function() {
    loginStore.set('phoneChecking', true);
    try{
      const result = await AsyncAjax.post( API.ENDPOINTS.CHECK_PHONE(), {
        phone: loginStore.get('phone')
      } );
      if(!result)
        throw new Error();
      if(result.userExist === false){
        loginStore.set('phoneErrorText', 'Пользователь с таким номером не зарегистрирован!');
        loginStore.set('phoneError', true);
      }else if(result.userExist === true){
        loginStore.set('active', 'enterCode');
        loginStore.set('phoneError', false);
      }
    }catch( e ){
      console.error(e);
      loginStore.set('phoneErrorText', 'Что-то пошло не так, проверьте соединение и обратитесь в поддержку!');
      loginStore.set('phoneError', true);
    }
    loginStore.set('phoneChecking', false);

  };
  loginStore.sub('phone', function (phone) {
    loginStore.set('phoneValid', phone.length === 11);
  });

  return <>
      <view.cmp.field.LabeledField required type={'tel'} bind={loginStore.bind('phone')}
        label={'Введите номер телефона, чтобы продолжить.'}
        disabled={loginStore.valTrue('phoneChecking')}
        placeholder={'Ваш телефон'}
                                   enterkeyhint={"send"}
        invalid={loginStore.valTrue('phoneError')}>
          <IF condition={loginStore.valTrue('phoneError')}>
              <span className={"field__error-message"}>{loginStore.val('phoneErrorText')}</span>
          </IF>
      </view.cmp.field.LabeledField>
      <Button class={"button button--primary authorization-form__button"}
        type={"button"} onclick={checkPhone}
        disabled={OR(
          loginStore.valFalse('phoneValid'),
          loginStore.valTrue('phoneChecking')
        )}>
          <span>Далее</span><Arr width="17" height="11"/>
      </Button>
  </>
});
