const dataProvider = {
    maxConnection: 0,
    maxTagID: 0,
    slice: {},

    tags: [],
    connections: {},
    products: {}
  },
  dP = dataProvider,
  initDataProvider = function(data) {
    Object.assign(dP, data);
    Object.assign(dP, {
      componentsList: [],
      componentsListHashByProduct: {}
    });

    let key;

    for(key in data.components){
      const cmp = data.components[key];
      cmp.tags = [];
      dP.componentsList.push(cmp);
      (dP.componentsListHashByProduct[cmp.id] || (dP.componentsListHashByProduct[cmp.id] = [])).push(cmp);
    }

    dP.tagsHash = data.tags.reduce((store, item)=>{
      dP.maxTagID = Math.max(dP.maxTagID, item.id);
      store[item.id] = item;
      return store
    }, {});

    for(key in data.products){
      let product = data.products[key];
      product.tags = [];
    }

    data.connections.forEach((connection) => {
      dP.maxConnection = Math.max(dP.maxConnection, connection.cid);
      if(connection.type === 0){
        data.products[connection.eid].tags.push(connection.tag)
      }
    });

  };
