import './Header.scss';
import Button from "/view/cmp/button/Button.jsx";
import Logo  from '/svg/logo.svg';
import User from "/svg/user.svg";
import Logout from "/svg/logout.svg";
import { Page } from "../../page/Page";
import Input from "../../cmp/field/Input";

const {IF, NOT, ELSE} = Store;
const Header = D.declare('view.block.Header', () => {
    const tempPageMenuHidden = new Store.Value.Boolean(true);
    const actions = {
        logo: 'Account',
        logout: function() {
            store.set('account.token', false);
            store.set('account.data', false);
        },
        profile: 'Profile'
    };

    tmpStore.sub('isMobile', (is)=> actions.profile = is ? 'Profile': 'Account');

    const action = function(name) {
        if(store.get('isTesting')){
            // TODO SHOW MODAL
        }else{
            if(typeof actions[name] === 'function'){
                actions[name]();
            }else{
                store.set( 'navigation.current', actions[name]);
            }
        }
    };
    return <header class={D.cls(
        "page-header", {
            "page-header--inner": (NOT(store.valEqual( 'navigation.current', 'Login')))
        })}   >
        <div class="button-temp">
            <button type={"button"} onClick={()=>tempPageMenuHidden.toggle()}>
                <IF condition={tempPageMenuHidden}>+<ELSE/>–</IF>
            </button>
            <div class={{'hidden': tempPageMenuHidden}}>{
                Object.keys(Page)
                  .map( name =>
                    <button class="temp-button" type={'button'} onClick={() => {
                        store.set('navigation.current', name);
                        tempPageMenuHidden.toggle();
                    }}>
                        {name}
                    </button>
                )
            }<div>New cards count <Input type={'number'} bind={tmpStore.bind('newItemCount')}/></div></div>
        </div>
        <IF condition={NOT(store.valEqual( 'navigation.current', 'Login'))}>
            <div className="page-header__wrapper">
                <Button class={"button page-header__logo-link page-header__logo"}
                        aria-label={"Перейти на главную страницу"}
                        onClick={()=>action('logo')}>
                    <Logo width="116" height="41"/>
                </Button>

                <div class="page-header__user-block">
                    <Button class={"button page-header__profile-link"}
                            aria-label={"Перейти на страницу профиля"}
                            onClick={()=>action('profile')}>
                        <User width="32" height="32"/>
                        <span>
                        {store.val('account.data.lastname')}{' '}
                        {store.val('account.data.firstname')}
                        </span>
                    </Button>
                    <Button class={"button page-header__logout-link"}
                            aria-label={"Выйти из аккаунта"}
                            onClick={()=>action('logout')}>
                        <Logout width="18" height="18"/><span>Выйти</span>
                    </Button>
                </div>
            </div>
        </IF>

    </header>
});

export default Header;
export {Header};