import './Field.scss';
import Input from './Input.jsx';

const LabeledField = D.declare('view.cmp.field.LabeledField', (cfg, children)=> {
  return <div class={D.cls( "field", cfg.cls, { "field--invalid": cfg.invalid } )}>
    <label class="field__label">
      <span class="field__label-text">{cfg.label}</span>
      <Input class="field__input" type={cfg.type} placeholder={cfg.placeholder} {...cfg}/>
    </label>
    {children}
  </div>
});

export default LabeledField;
export {LabeledField};