import Info from '/view/block/info/Info.jsx';
import Button from '/view/cmp/button/Button.jsx';
import Arr from '/svg/arr.svg';
import './welcomePage.scss';

export default D.declare('view.page.Account', () =>
    <div class="welcome-page">
        <div class="welcome-page__wrapper">
            <Info
                img={
                    <picture>
                        <source srcset="/uploads/images/assistant-welcome-mob.svg" media={"(max-width: 767px)"}/>
                        <img src="/uploads/images/assistant-welcome.svg" width="450" height="360" alt={"Изображение помощника"}/>
                    </picture>
                    }
                buttons={
                    <Button class={"button button--primary welcome-page__button"} type={"button"}>
                        <span>Продолжить</span><Arr width="17" height="11"/>
                    </Button>
                }>
                <div className="welcome-page__message">
                    <h1 className="welcome-page__title">Добро пожаловать!</h1>
                    <div className="welcome-page__text">
                        <p>Текст про портал и&nbsp;приветственное сообщение.</p>
                        <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do&nbsp;eiusmod tempor incididunt ut&nbsp;labore et&nbsp;dolore magna aliqua. Ut&nbsp;enim ad&nbsp;minim veniam, quis nostrud exercitation ullamco laboris nisi ut&nbsp;aliquip ex&nbsp;ea&nbsp;commodo consequat. Duis aute irure dolor in&nbsp;reprehenderit in&nbsp;voluptate velit esse cillum dolore eu&nbsp;fugiat nulla pariatur.</p>
                    </div>
                </div>
            </Info>
            <Info
                img={
                    <picture>
                        <source srcset="/uploads/images/assistant-top-mob.svg" media={"(max-width: 767px)"}/>
                        <img src="/uploads/images/assistant-top.svg" width="450" height="360" alt={"Изображение помощника"}/>
                    </picture>
                }
                buttons={[
                    <Button class={"button button--bordered welcome-page__button"} type={"button"}>
                        <span>Посмотреть мои ответы</span>
                    </Button>,
                    <Button class={"button button--primary welcome-page__button"} type={"button"}>
                        <span>Завершить тестирование</span><Arr width="17" height="11"/>
                    </Button>
                ]}>
                <div className="welcome-page__message welcome-page__message--result welcome-page__message--top">
                    <h1 className="welcome-page__title"><em>Поздравляем!</em> Вы вошли в ТОП лучших ответов!</h1>
                    <div className="welcome-page__text">
                        <p>Ваш результат: <b class="result">98<sup>%</sup></b></p>
                        <p>Вы верно ответили на <em>19</em> вопросов из 20.</p>
                        <p><em>ТОП лучших ответов означает, что в&nbsp;следующем тестировании вам нужно будет ответить на&nbsp;меньшее количество вопросов. Отличная работа! Мы&nbsp;гордимся вами!</em></p>
                    </div>
                </div>
            </Info>
            <Info
                img={
                    <picture>
                        <source srcset="/uploads/images/assistant-fail-mob.svg" media={"(max-width: 767px)"}/>
                        <img src="/uploads/images/assistant-fail.svg" width="450" height="360" alt={"Изображение помощника"}/>
                    </picture>
                }
                buttons={[
                    <Button class={"button button--bordered welcome-page__button"} type={"button"}>
                        <span>Посмотреть мои ответы</span>
                    </Button>,
                    <Button class={"button button--primary welcome-page__button"} type={"button"}>
                        <span>Завершить тестирование</span><Arr width="17" height="11"/>
                    </Button>
                ]}>
                <div className="welcome-page__message welcome-page__message--result welcome-page__message--fail">
                    <h1 className="welcome-page__title">Тестирование завершено</h1>
                    <div className="welcome-page__text">
                        <p>Ваш результат: <b class="result">55<sup>%</sup></b></p>
                        <p>Вы верно ответили на <em>9</em> вопросов из 20.</p>
                        <p><em>К&nbsp;сожалению, это очень низкий результат. Мы&nbsp;верим, что вы&nbsp;можете лучше! При подготовке к&nbsp;следующему тестированию, попробуйте потренироваться на&nbsp;пробном тесте или почитать нашу базу знаний.</em></p>
                    </div>
                </div>
            </Info>
            <Info
                img={
                    <picture>
                        <source srcset="/uploads/images/assistant-success-mob.svg" media={"(max-width: 767px)"}/>
                        <img src="/uploads/images/assistant-success.svg" width="450" height="360" alt={"Изображение помощника"}/>
                    </picture>
                }
                buttons={[
                    <Button class={"button button--bordered welcome-page__button"} type={"button"}>
                        <span>Посмотреть мои ответы</span>
                    </Button>,
                    <Button class={"button button--primary welcome-page__button"} type={"button"}>
                        <span>Завершить тестирование</span><Arr width="17" height="11"/>
                    </Button>
                ]}>
                <div className="welcome-page__message welcome-page__message--result welcome-page__message--success">
                    <h1 className="welcome-page__title"><em>Поздравляем!</em> Вы завершили тестирование!</h1>
                    <div className="welcome-page__text">
                        <p>Ваш результат: <b class="result">80<sup>%</sup></b></p>
                        <p>Вы верно ответили на <em>16</em> вопросов из 20.</p>
                    </div>
                </div>
            </Info>
        </div>
    </div>
)
