import Button from '../../cmp/button/Button.jsx';
import Arr from '/svg/arr.svg';
import IconTest from '/svg/icon-testing.svg';
import IconTrial from '/svg/icon-trial.svg';
import IconBase from '/svg/icon-base.svg';
import IconResult from '/svg/icon-result.svg';
import './accountNavigation.scss';

const AccountNavigation = D.declare('view.block.AccountNavigation', () => {
    return <div class="account-navigation">
        <h2 class="account-navigation__title">Сегодня вы можете:</h2>
        <ul className="account-navigation__list">
            <li className="account-navigation__item">
                <Button class={"button button--secondary account-navigation__button"}>
                    <IconTest width="32" height="32"/>
                    <span>Пройти итоговое тестирование</span>
                    <Arr width="17" height="11"/>
                </Button>
            </li>
            <li className="account-navigation__item">
                <Button class={"button button--secondary account-navigation__button"}>
                    <IconTrial width="32" height="32"/>
                    <span>Пройти пробное тестирование</span>
                    <Arr width="17" height="11"/>
                </Button>
            </li>
            <li className="account-navigation__item">
                <Button class={"button button--secondary account-navigation__button"}>
                    <IconBase width="32" height="32"/>
                    <span>Посмотреть базу знаний</span>
                    <Arr width="17" height="11"/>
                </Button>
            </li>
            <li className="account-navigation__item">
                <Button class={"button button--secondary account-navigation__button"}>
                    <IconResult width="32" height="32"/>
                    <span>Все результаты моих тестов</span>
                    <Arr width="17" height="11"/>
                </Button>
            </li>
        </ul>
    </div>
})

export default AccountNavigation;
export {AccountNavigation};
