const Consts = {
  ANCHORS: {
    EXIT: "#exit",
  },
  API: {
    ENDPOINTS: {
      // Auth Endpoints
      SEND_CODE: "/api/login/send_code",
      CHECK_CODE: "/api/login/check_code",

      CHECK_PHONE: "/api/login/check_phone",
      CHECK_ID_TOKEN: "/api/login/check_id_token",


      // Testing Endpoints
      GET_TESTING_LIST: "/api/quizzes",
      PUT_TESTING_LIST: id => `/api/quizzes/${id}`,
      GET_ACTIVE_TESTING: "/api/quiz/active",
      CREATE_TESTING_ATTEMPT: "/api/quiz_attempt_create",
      GET_TESTING_ATTEMPT: id => `/api/quiz_attempts/${id}`,
      GET_TESTING_QUESTION: id => `/api/quiz_questions/${id}`,
      SEND_QUESTION_ANSWERS: id => `/api/quiz_questions/${id}`,
      INTERRUPT_TEST: id => `/api/quiz_attempt/abort/${id}`,
      // Employees Endpoints
      GET_USERS_LIST: "/api/users",
      EDIT_USER: id => `/api/users/${id}`,
      // Employee Positions
      GET_POSITIONS: "/api/employee_positions",
      // Knowledge Endpoints
      GET_CARD_PRODUCTS: "/api/card_products",
      GET_CARD_INFOS: "/api/card_infos",
      GET_CARD_PRODUCTS_ITEM: id => `/api/card_products/${id}`,
      GET_CARD_INFO_CARD: id => `/api/card_infos/${id}`,
      //REDUNDANT GET_CARD_INFO_ITEM: id => `/api/card_info_items/${id}`,
      CATEGORIES_CATEGORY: id => `/api/categories/${id}`,
      // Categories
      GET_CATEGORIES: "/api/categories",
      // Account Endpoints
      GET_USER: id => `/api/users/${id}`,
      GET_USER_NEW_CARDS: "/api/history/cards/new",
      GET_USER_QUIZ_ATTEMPT_ID: "/api/quiz_attempt/last",
      GET_USER_QUIZ_ATTEMPTS_BY_ID: id => `/api/quiz_attempts/${id}`
    },
    HEADERS: {
      DEFAULT: {
        "Content-Type": "application/json",
      },
    },
    DELAY: {
      DEFAULT_MS: 1000,
      FILTERS_MS: 500,
    },
    METHODS: {
      GET: "GET",
      POST: "POST",
      PUT: "PUT",
      DELETE: "DELETE",
    },
    STATUS_REQUEST: {
      NONE: "NONE",
      FETCHING: "FETCHING",
      DONE: "DONE",
    },
  },

  ENV: {
    DEVELOPMENT: "development",
    PRODUCTION: "production",
    //NODE_ENV: process.env.NODE_ENV,
    IS_DEVELOPMENT: null,
    BASE_URL: null,
  },

  ERRORS: {
    API: {
      NO_ENDPOINT: "NO_ENDPOINT",
    },
  },

  DOM: {
    ROOT: "root",
  },

  LOCAL_STORAGE: {
    TOKEN: {
      TOKEN: "token",
      GET_TOKEN: null,
    },
    EMPLOYEE: {
      IS_LOGGES_FIRST_TIME: "isLoggedFirstTime",
    },
    ROLES: "roles",
    ROLE: "role",
    USER_ID: "userId",
    TESTING: {
      QUESTION_NUMBER: "questionNumber",
      ATTEMPT_ID: "attemptId",
      TIMER_VALUE: "timerValue",
      RESULT_ID: "resultId",
      INTERRUPT_TEST: "interruptTest",
      DURATION: 'duration'
    },
  },

  ROLES: {
    ADMIN: "ROLE_ADMIN",
    VISITOR: "ROLE_VISITOR",
    EMPLOYEE: "ROLE_EMPLOYEE",
  },

  ROUTES: {
    MAIN: "/",
    ADMIN: {
      MAIN: "/admin",
      EMPLOYEES: "/admin/employees",
      CONTENTS: "/admin/contents",
      TESTING: "/admin/testing",
      STATISTICS: "/admin/statistics",
    },
    LOGIN: {
      MAIN: "/login",
      LOGIN_ENTRY: "/login/entry",
      LOGIN_INFO: "/login/info",
      CHANGE_ROLE: "/login/change_role",
    },
    EMPLOYEE: {
      ACCOUNT: {
        MAIN: "/account",
        PERSONAL: "/account/personal",
        GREETING: "/account/greeting",
      },
      TESTING: {
        MAIN: "/account/testing",
        TESTING_NOT_ACTIVATED: "/account/testing/not_activated",
        TESTING_CONFIRMATION: "/account/testing/confirmation",
        TESTING_TEST: questionId => `/account/testing/test/${questionId}`,
        TESTING_HIGH_RESULT: "/account/testing/high_result",
        TESTING_TOP_RESULT: "/account/testing/top_result",
        TESTING_RESULT: "/account/testing/result",
        TESTING_ANSWERS: "/account/testing/answers",
        TESTING_FINISH: "/account/testing/finish",
        TESTING_INTERRUPT: "/account/testing/interrupt",

        MOCK_TESTING_HIGH_RESULT: "/account/mock/testing/high_result",
        MOCK_TESTING_TOP_RESULT: "/account/mock/testing/top_result",
        MOCK_TESTING_RESULT: "/account/mock/testing/result",
      },
      KNOWLEDGE_BASE: {
        MAIN: "/account/knowledge_base",
        KNOWLEDGE_BASE_TOP: categoryId => `/account/knowledge_base/top/${categoryId}`,
        KNOWLEDGE_BASE_CARD: (categoryId, cardId) =>
          `/account/knowledge_base/card/${categoryId}/${cardId}`,
      },
    },
  },
  PAGINATE: {
    MAX_PAGES: 19,
  },
  TESTING: {
    LIST: {
      ITEMS_PER_PAGE: 20,
    },
  },
  EMPLOYEES: {
    LIST: {
      ITEMS_PER_PAGE: 20,
    },
  },
  POSITIONS: {
    LIST: {
      ITEMS_PER_PAGE: 20,
    },
  },
  MODAL: {
    EDIT: {
      WIDTH: "1060px",
      HEIGHT: "730px",
    },
    ACTIVATED: {
      HEIGHT: "300px",
    },
    ERROR: {
      HEIGHT: "420px",
    },
    CONFIRM: {
      HEIGHT: "440px",
    },
    EDIT_CONFIRM: {
      HEIGHT: "420px",
    },
    SMS: {
      HEIGHT: "690px",
      WIDTH: "1060px",
    },
  },
  FORMS: {
    INPUT: {
      MAX_SIZE: 100,
    },
  },
  DATE_FORMATS: {
    DEFAULT: "dd.MM.yyyy",
    MONTH_YEAR: "LLLL yyyy",
    DAY_MONTH: "dd.MM",
  },
};

Consts.LOCAL_STORAGE.TOKEN.GET_TOKEN = (token) => `Bearer ${token}`

Consts.ENV.IS_DEVELOPMENT = Consts.ENV.NODE_ENV === Consts.ENV.DEVELOPMENT
Consts.ENV.BASE_URL = 'https://api.local.vkusvill.testin.ru';/*Consts.ENV.IS_DEVELOPMENT
  ? `${window.location.protocol}//${window.location.hostname}`//${window.location.port!=="80"?':'+window.location.port:''}`
  : window.location.origin*/
for(let key in Consts.API.ENDPOINTS){
  const ENDPOINT = Consts.API.ENDPOINTS[key];
  Consts.API.ENDPOINTS[key] = (data)=>{
    return Consts.ENV.BASE_URL + (typeof ENDPOINT === 'function' ? ENDPOINT(data): ENDPOINT);
  };
}

export default Consts
const API = Consts.API;
export {API};
export {Consts};
