import './accountPage.scss';
import AccountBlock from '../../block/account/Account.jsx';
import Button from "/view/cmp/button/Button.jsx";
import Eye from '/svg/eye.svg';
import '../../block/card/card.scss';

const Account = D.declare('view.page.Account', () => {
    store.sub([
      'isMobile', 'navigation.current'
    ], (is, page)=>{
        if(!is && page === 'Profile')
            store.set('navigation.current', 'Account');
    });

    return <div class="account-page">
        <h1 class="readers-only">Страница личного кабинета сотрудника</h1>
        <div class="account-page__wrapper">
            <div class="account-page__menu">
                <div class="account-page__menu-inner">
                    <AccountBlock />
                </div>
            </div>
            <div class="account-page__content">
                <div class="account-page__content-inner">
                    <div class="cards-list">
                        <h2 class="readers-only">Список непросмотренных карточек</h2>
                        <div class="cards-list__item">
                            <div class="card card--info">
                                <div class="card__image">
                                    <img src="/uploads/images/card_product1.jpg" alt=""/>
                                </div>
                                <h3 class="card__title">Название карточки</h3>
                                <div class="card__footer">
                                    <Button class={"button card__button"}>
                                        <span>Изучить</span>
                                    </Button>
                                </div>
                            </div>
                        </div>
                        <div class="cards-list__item">
                            <div class="card card--product">
                                <div class="card__image">
                                    <img src="/uploads/images/card_product2.jpg" alt=""/>
                                </div>
                                <h3 class="card__title">Название карточки</h3>
                                <div class="card__footer">
                                    <Button class={"button card__button"}>
                                        <span>Изучить</span>
                                    </Button>
                                </div>
                            </div>
                        </div>
                        <div class="cards-list__item">
                            <div class="card card--other">
                                <div class="card__image">
                                    <img src="/uploads/images/card_product3.jpg" alt=""/>
                                </div>
                                <h3 class="card__title">Название карточки</h3>
                                <div class="card__footer">
                                    <Button class={"button card__button"}>
                                        <span>Изучить</span>
                                    </Button>
                                </div>
                            </div>
                        </div>
                        <div class="cards-list__item">
                            <div class="card card--seen">
                                <div class="card__image">
                                    <img src="/uploads/images/card_product4.jpg" alt=""/>
                                </div>
                                <h3 class="card__title">Название карточки</h3>
                                <div class="card__footer">
                                    <div class="card__note">
                                        <span>Просмотрена</span>
                                        <Eye width="20" height="13" />
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="cards-list__item">
                            <div class="card card--disabled">
                                <div class="card__image">
                                    <img src="/uploads/images/card-disabled.png" alt=""/>
                                </div>
                                <h3 class="card__title">Карточек нет</h3>
                                <div class="card__footer">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
});

export default Account;
export {Account};
