view.cmp.Answer = function(answer, type) {
  return (
  <label cls={D.cls('quiz-answer-label', 'quiz-answer-label__'+type)}>
    <input type={type} checked={answer.correct}/>{answer.text}
  </label>
  )
};

view.page.Generate = function() {
  const update = function() {
    const photo = store.get('generatePhoto') === 'photo',
      type = store.get('generateType'),
      category = store.get('generateCategory');

      try{
        seedInput.value = Math.random.seeded.getStringSeed();

        const result = category === 'product' ? quizGenerator( type, photo ) : standardGenerator(({length})=>rand(0,length-1));

        title.innerHTML = textFormat( result.question, true );
        image.innerHTML = result.image ? `<img src="${result.image}" alt="img"/>` : '';
        image.style.display = result.image ? 'block': 'none';
        debug.value = result.log.join( '\n' )
        D.removeChildren( answers );
        D.appendChild( answers, result.answers.map( ( a ) => view.cmp.Answer( a, type ) ) );
      }catch( e ){
        debug.value = quizGenerator.log.join( '\n' )
        console.error(e)
      }
  };

  let title, answers, debug, seedInput, image;

  this.dom =
    <div cls='generate-panel'>
      <div cls='title-gradient'>
        <div cls='generate-sub-menu'>
          <div cls='generate-sub-menu'>
            {view.cmp.Menu({title: 'Продукты', id: 'product', key: 'generateCategory'})}
            {view.cmp.Menu({title: 'Стандарты', id: 'standard', key: 'generateCategory'})}
          </div>
          {view.cmp.Switch({key: 'generateCategory'}, {
            product: <div cls='generate-sub-menu'>
              <div cls='generate-sub-menu'>
                {view.cmp.Menu({title: 'Единственный', id: 'radio', key: 'generateType'})}
                {view.cmp.Menu({title: 'Множественный', id: 'checkbox', key: 'generateType'})}
              </div>

              <div cls='generate-sub-menu'>
                {view.cmp.Menu({title: 'С фото', id: 'photo', key: 'generatePhoto'})}
                {view.cmp.Menu({title: 'Без фото', id: 'noPhoto', key: 'generatePhoto'})}
              </div>
            </div>
          })}
              
        </div>
      </div>
      <div cls='generate-controls'>
        <input type='button' value='F5' onclick={update}/>
        <span cls='generate-seed-label'>Seed:</span>
        {seedInput = <input
          cls='seed'
          type='input' value='' placeholder='seed'
          oninput={function() {
            var val = seedInput.value;
            Math.random.seeded.setStringSeed(val);
            update()
          }}/>
        }

      </div>

      <div cls='generate-example'>
        {title = <div cls='generate-title'/>}
        {image = <div cls='generate-image'/>}
        {answers = <div cls='generate-answers'/>}
        {debug = <textarea cls='generate-debug'/>}
      </div>
  </div>;

  store.sub(['generateType', 'generatePhoto', 'generateCategory'], update);

};