import {ACTION} from "/controller/Action";
import Button from "/view/cmp/button/Button.jsx";
import Arr from "/svg/arr.svg";
import Info from "/view/block/info/Info";

const WelcomeDemoFinal = D.declare( 'view.page.WelcomeDemoFinal', () => {
  return <div className="welcome-page">
    <div className="welcome-page__wrapper">
      <Info
        img={
          <picture>
            <source srcset="/uploads/images/assistant-final-mob.svg" media={"(max-width: 767px)"}/>
            <img src="/uploads/images/assistant-final.svg" width="450" height="360" alt={"Изображение помощника"}/>
          </picture>
        }
        buttons={[
          <Button class={"button button--primary button-orange welcome-page__button welcome-page__button--wide"} type={"button"}
            onclick={ACTION.TEST.DEMO.GOTO_FINAL_LAST_NOTIFICATION.execute}>
            <span>Начать тестирование</span><Arr width="17" height="11"/>
          </Button>
        ]}>
        <div className="welcome-page__message">
          <h1 className="welcome-page__title">Добро пожаловать в&nbsp;пробное итоговое тестирование!</h1>
          <div className="welcome-page__text">
            <p>Текст про тестирование и&nbsp;его правила. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do&nbsp;eiusmod tempor incididunt ut&nbsp;labore et&nbsp;dolore magna aliqua.</p>
            <p class="welcome-page__date">Тестирование проходит в&nbsp;период: <time>25.08-30.08</time></p>
          </div>
        </div>
      </Info>
    </div>
  </div>
} );

export default WelcomeDemoFinal;
export { WelcomeDemoFinal };
