quizTypes.checkboxPhoto = [
  {
    questionMinComponentsCount: 2,
    probability: 8,
    type: 'What components are in it',

    answers: {min: 3, max: 6},
    correct: {min: 2, max: 4},
    wrong: {min: 1, max: 4},

    from: qB.prebuild.similarTaggedProductWithPhotoAndComponents.fn,
    question(income, log){
      return 'Какие ингредиенты входят в продукт, изображенный на картинке?'
    },
    answer( income, log ){
      let corrects = income.allCorrect
          .slice(0, rand(this.correct))
          .map(a=>new Answer.Correct(textFormat(a.name))),

        wrongs = income.allWrong
          .slice(0, rand(this.wrong))
          .map(a=>new Answer.Wrong(textFormat(a.name)));

      return shuffle(
        corrects
          .concat(wrongs)
          .slice(
            0,
            Math.min(
              this.answers.max,
              corrects.length+wrongs.length)));
    }
  },
  {
    questionMinComponentsCount: 2,
    probability: 0,//3,
    type: 'What components are NOT in it',

    answers: {min: 3, max: 6},
    correct: {min: 2, max: 4},
    wrong: {min: 1, max: 4},

    from: qB.prebuild.similarTaggedProductWithPhotoAndComponents.fn,
    question(income, log){
      return 'Какие ингредиенты НЕ входят в продукт, изображенный на картинке?'
    },
    answer( income, log ){
      let corrects = income.allWrong
          .slice(0, rand(this.correct))
          .map(a=>new Answer.Correct(textFormat(a.name))),

        wrongs = income.allCorrect
          .slice(0, rand(this.wrong))
          .map(a=>new Answer.Wrong(textFormat(a.name)));

      return shuffle(
        corrects
          .concat(wrongs)
          .slice(
            0,
            Math.min(
              this.answers.max,
              corrects.length+wrongs.length)));
    }
  }
];