import '../../cmp/field/LabeledField.jsx';
import Logo from '../../../svg/logo_vkusvill.svg';
import './loginPage.scss';

export default D.declare('view.page.Login', () => {
    const loginStore = new Store({
       phone: '7',
       code: '',
       active: 'enterPhone',
        phoneValid: false
    });
    loginStore.sub('phone', function (phone) {
       loginStore.set('phoneValid', phone.length === 11);
    });
    return <div className={"login-page"}>
        <div class="login-page__big-logo">
            <Logo width="660" height="300"/>
        </div>
        <h1 className="login-page__title">Добро пожаловать в&nbsp;развивающую платформу Вкусвилл!</h1>
        <form action="#" method="post" className="authorization-form">
            {view.cmp.Switch({store: loginStore, key: 'active'}, {
                enterPhone: [
                    <view.cmp.field.LabeledField label={'Введите номер телефона, чтобы продолжить.'} bind={loginStore.bind('phone')}/>,
                    <button
                        class={"btn btn--primary authorization-form__btn"}
                        onclick={()=>loginStore.set('active', 'enterCode')}
                        disabled={_=>loginStore.equal('phoneValid', false, _)}
                    >Ага</button>
                ],
                enterCode: [
                    <button onClick={() => loginStore.set('active', 'enterPhone')}>Взат</button>,
                    <view.cmp.field.LabeledField label={'Code'}/>
                ]
            })}
        </form>
    </div>
})
