import './infoCard.scss';
import Button from "../button/Button";
import Back from '/svg/arr-back.svg';
import Arr from '/svg/arr.svg';
import Info from '/svg/info.svg';

const InfoCard = D.declare('view.cmp.InfoCard', (cfg) => {
    return <div class="info-card">
        <div className="info-card__header">
            <h1 className="info-card__title">Печенье "Орешки"</h1>
            <p className="info-card__category">Категория Топ 35</p>
            <div className="info-card__stats">
                <p>Карточек в категории: <b>20</b></p>
                <p>Просмотрено: <em>2</em></p>
            </div>
        </div>
        <div className="info-card__body">
            <div className="info-card__image">
                <img src="/uploads/images/product1.jpg" alt=""/>
            </div>
            <div className="info-card__list">
                <h2>Ингредиенты</h2>
                <ul>
                    <li>Вареная сгущенка </li>
                    <li>Мука </li>
                    <li>Масло сливочное </li>
                    <li>Сахар </li>
                    <li>Ингредиент</li>
                </ul>
            </div>
            <div className="info-card__text">
                <Info width="30" height="30"/>
                <p><b>Важно знать.</b>Информация о&nbsp;продукте. Все, что вы&nbsp;хотели знать, но&nbsp;боялись спросить.</p>
                <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi lacinia augue quam, in&nbsp;dapibus nulla ullamcorper nec. Mauris ac&nbsp;magna est. Vivamus dapibus venenatis nisi, sit amet dictum tellus aliquam sit amet. Proin sit amet suscipit nisl. </p>
                <p>Mauris ac&nbsp;magna est. Vivamus dapibus venenatis nisi, sit amet dictum tellus aliquam sit amet. Proin sit amet suscipit nisl.</p>
            </div>
        </div>
        <div className="info-card__footer">
            <Button class={"button info-card__link"}><Back width="17" height="11"/><span>Предыдущая карточка</span></Button>
            <Button class={"button info-card__link"}><span>Следующая карточка</span><Arr width="17" height="11"/></Button>
        </div>
    </div>
})

export default InfoCard;
export {InfoCard};
