import './infoCard.scss';
import Button from "../button/Button";
import ProductCard from '../productCard/ProductCard.jsx';
import PaginationSlider from '../paginationSlider/PaginationSlider.jsx';

import Back from '/svg/arr-back.svg';
import Arr from '/svg/arr.svg';

const InfoCard = D.declare('view.cmp.InfoCard', ({item, category}) => {
    console.log({item, category})

    let backHidden = true,
      forwardHidden =  true,
      sorted = [];
    try{
        sorted = category[item.type === 1?'cardProduct':'cardInfo'].slice().sort((a,b)=>a.id - b.id);
        backHidden = sorted[0].id === item.id;
        forwardHidden = sorted[sorted.length - 1].id === item.id;
    }catch(e){
        console.error('format changed', category);
    }
    let next = function(){
          if( forwardHidden )
              return false;

          for( let i = 0, _i = sorted.length; i < _i; i++ ){
              if( sorted[ i ].id === item.id ){
                  store.set( 'navigation.data.id', sorted[ i + 1 ].id );
                  break;
              }
          }
      },
      back = function() {
          if(backHidden)
              return false;

          for( let i = 0, _i = sorted.length; i < _i; i++ ){
              if( sorted[ i ].id === item.id ){
                  store.set( 'navigation.data.id', sorted[ i - 1 ].id );
                  break;
              }
          }
      };
    let content;
    if(item.type === 1){
        content = <ProductCard item={item} category={category}/>;
    }else{
      content = <PaginationSlider item={item} category={category}/>;
    }
    return <div class="info-card">
        <div className="info-card__header">
            <div>TYPE: {item.type}</div>
            <div className="info-card__headline">
              <h1 className="info-card__title">{item.name}</h1>
              <p className="info-card__category">{category.name}</p>
            </div>
            <div className="info-card__stats">
                <p>Карточек в категории: <b>{category.count||0}</b></p>
                <p>Просмотрено: <em>{category.countView||0}</em></p>
            </div>
        </div>
        <div className="info-card__body">
            {content}
        </div>
        <div className="info-card__footer">
            <Button class={D.cls("button info-card__link", {'info-card__link-hidden': backHidden})} onclick={back}><Back width="17" height="11"/><span>Предыдущая карточка</span></Button>
            <Button class={D.cls("button info-card__link", {'info-card__link-hidden': forwardHidden})} onclick={next}><span>Следующая карточка</span><Arr width="17" height="11"/></Button>
        </div>
    </div>
})

export default InfoCard;
export {InfoCard};



























