import './Header.scss';
import Button from "/view/cmp/button/Button.jsx";
import Logo  from '/svg/logo.svg';
import User from "/svg/user.svg";
import Logout from "/svg/logout.svg";
import { Page } from "../../page/Page";

const {IF, NOT} = Store;
const Header = D.declare('view.block.Header', () => {
    const tempPageMenuHidden = new Store.Value.Boolean(true);
    return <header class={D.cls(
        "page-header", {
            "page-header--inner": (NOT(store.valEqual( 'navigation.current', 'login')))
        })}   >
        <div class="button-temp">
            <button type={"button"} onClick={()=>tempPageMenuHidden.toggle()}>
                <IF condition={tempPageMenuHidden}>+</IF>
                <IF condition={NOT(tempPageMenuHidden)}>–</IF>

            </button>
            <div cls={D.cls({'hidden': tempPageMenuHidden})}>{
                Object.keys(Page)
                  .map( name =>
                    <button class="temp-button" type={'button'} onClick={() => {
                        store.set('navigation.current', name);
                        tempPageMenuHidden.toggle();
                    }}>
                        {name}
                    </button>
                )
            }</div>
        </div>
        <IF condition={NOT(store.valEqual( 'navigation.current', 'Login'))}>
            <div className="page-header__wrapper">
                <a href="#" class="page-header__logo" aria-label={"Логотип ВкусВилл"}>
                    <Logo width="116" height="41"/>
                </a>
                <div class="page-header__user-block">
                    <Button class={"button page-header__profile-link"}
                            type={"button"}
                            aria-label={"Перейти на страницу профиля"}
                            >
                        <User width="32" height="32"/><span>Иванов Иван</span>
                    </Button>
                    <Button class={"button page-header__logout-link"}
                            type={"button"}
                            aria-label={"Выйти из аккаунта"}
                    >
                        <Logout width="18" height="18"/><span>Выйти</span>
                    </Button>
                </div>
            </div>
        </IF>

    </header>
});

export default Header;
export {Header};