export default D.declare('Switch', (cfg, contentHash) => {
  if(Array.isArray(contentHash)){
    contentHash = contentHash.reduce(function(store, {id, children}) {
      store[id] = children;
      return store;
    }, {});
  }

  const cmp = div( {
    cls: update => (cfg.store || store).sub(
      cfg.key,
        val => update(
          D.cls(
            'cmp-switch',
            cfg.cls,
            { 'cmp-switch__filled': val in contentHash } ) ) ) } );

  (cfg.store || store).sub( cfg.key, (val)=> {
    D.removeChildren(cmp);
    if(val in contentHash)
      D.appendChild( cmp, contentHash[ val ] );

  });

  return cmp;
});

Switch.Item = function(cfg, children) {
  if(!(this instanceof Switch.Item)){
    return new Switch.Item(cfg, children);
  }
  this.id = cfg.id;
  this.children = children;
};