dP.Product = {
  getByID: function(id) {
    return dP.products[id];
  },
  getComponents: function(product) {
    return dP.componentsListHashByProduct[ product.id ] || [];
  },
  getTags: function(product) {
    return product.tags.map(dP.Tag.getByID);
  },
  get: function() {

  },
  ctor: function(data) {
    this.tags = [];
    Object.assign(this, data);
  }
};

dP.Product.ctor.prototype = {
  getComponents(){return dP.Product.getComponents(this);},
  getTags(){return dP.Product.getTags(this);},
  containsComponent(cmp, fuzzy){
    if(!fuzzy)
      return this.getComponents().indexOf(cmp)>-1;

    const normalized = normalizeText(cmp.name);
    return this.getComponents().filter(sCmp=>normalized === normalizeText(sCmp.name) ).length > 0;
  }
};