import Button from "/view/cmp/button/Button.jsx";
import { AsyncAjax } from "/core/Ajax.jsx";
import { API } from "/dict/Consts.jsx";
import Arr  from '/svg/arr.svg';
import { AsyncAuthAjax } from "../../../controller/Ajax";

const {AND, OR, IF} = Store;
const LoginCode = D.declare('view.page.LoginCode', ({loginStore}) => {
  const checkCode = async function () {
    loginStore.set('codeChecking', true);
    loginStore.set('codeError', false);
    try{
      // TODO: GET AUTH TOKEN. SOMEHOW
      const result = await AsyncAjax.post( API.ENDPOINTS.CHECK_PHONE(), {
        phone: loginStore.get('phone')
      } );
      store.set('account.token', 'eyJhbGciOiJSUzI1NiIsImtpZCI6IjI1OTc0MmQyNjlhY2IzNWZiNjU3YzBjNGRkMmM3YjcyYWEzMTRiNTAiLCJ0eXAiOiJKV1QifQ.eyJpc3MiOiJodHRwczovL3NlY3VyZXRva2VuLmdvb2dsZS5jb20vdGVzdHZrdXN2aWxsIiwiYXVkIjoidGVzdHZrdXN2aWxsIiwiYXV0aF90aW1lIjoxNTgwMzk4NDM3LCJ1c2VyX2lkIjoiMEU5TkNIM2xXTFZOaXJuRnEzU1VHWlI2NFVzMSIsInN1YiI6IjBFOU5DSDNsV0xWTmlybkZxM1NVR1pSNjRVczEiLCJpYXQiOjE1ODAzOTg0MzcsImV4cCI6MTU4MDQwMjAzNywicGhvbmVfbnVtYmVyIjoiKzc5OTk5ODc3NDE0IiwiZmlyZWJhc2UiOnsiaWRlbnRpdGllcyI6eyJwaG9uZSI6WyIrNzk5OTk4Nzc0MTQiXX0sInNpZ25faW5fcHJvdmlkZXIiOiJwaG9uZSJ9fQ.r3ksno8TtD9DniAUg0Q-lwsPgIGKa3cqdazb2REm_DqyRdWUv0hy8NJQjFfacvo02RuvMrWqFslZCGzuPj66snfRwCdp2FIsX4FWG38eMGXbprZHww4vrT9KXfY4UEcry4fA11XJkMRVDjTM1J9jvuy63C8zdbExaHi2eOYsbuinkJNdbZTkFVTAYTickXfM7l8zAwlKIJxl3Y2DLQzmxh0RuJgi981FGUaUcZONbMfXA4nx4o2r2Xpd-uantqAUwAHRecsuoxsba6G20bROJxJjDSAnmBGXYt-pYtWm2JX5deZ6kia7pgB8ivuezRO3r4aZWzUUaK7wJ-oPicPOtQ')
    }catch(e){
      loginStore.set('codeChecking', false);
      loginStore.set('codeError', true);
    }
  };
  loginStore.sub('code', function (code) {
    loginStore.set('codeValid', (code+'').length === 6);
  });

  return <>
      <view.cmp.field.LabeledField required label={'Введите код из СМС'}
        placeholder={'Код'} type={'number'}
        disabled={loginStore.valTrue('codeChecking')}
        bind={loginStore.bind('code')}
        invalid={loginStore.valTrue('codeError')}>
          <IF condition={loginStore.valTrue('codeError')}>
              <span className={"field__error-message"}>Некорректный код. Попробуйте еще раз</span>
          </IF>
      </view.cmp.field.LabeledField>

      <Button class={"button button--primary authorization-form__button"}
        type={"button"} onclick={checkCode}
        disabled={OR(
          loginStore.valFalse('codeValid'),
          loginStore.valTrue('codeChecking')
        )}>
          <span>Далее</span><Arr width="17" height="11"/>
      </Button>
  </>
});

export default LoginCode;
export {LoginCode};