import './account.scss';
import User from "/svg/user.svg";
import Rating from '../ratingBlock/Rating.jsx';

const AccountBlock = D.declare('view.block.AccountBlock', () => {
    return <div class="account">
        <h2 class="account__headline">Личный кабинет</h2>
        <div class="account__info">
            <h3 class="account__name">
                <User width="32" height="32"/>
                <span>
                    {(update)=>store.sub([
                        'account.data.firstname',
                        'account.data.middlename',
                        'account.data.lastname'
                    ], (f, m, l)=>
                      update(
                        [l,f,m]
                            .join(' ')
                            .split(/\s+/)
                            .map(word => <div class="title-name-word">{word}</div>)
                      )
                    )}
                </span>
            </h3>
            <p>{store.val('account.data.location')}</p>
            <p>{store.val('account.data.position.title')}</p>
        </div>
        <div class="account__rating">
            <Rating/>
        </div>
    </div>
});

export default AccountBlock;
export {AccountBlock};
