const Observable = global.Observable = require('../src/core/Observer');
const Store = require('../src/core/data/store/Store');
const assert = require('chai').assert;

describe('store', function() {

    it('should set and get simple values', function() {
        const s = new Store({});
        s.set('a', 5);
        assert.equal(s.get('a'), 5);
        s.set('b', 'abc');
        assert.equal(s.get('b'), 'abc');
        assert.equal(s.get('a'), 5);
        s.set('c', [1,2,3]);
        assert.deepEqual(s.get('c'), [1,2,3]);
    });
    it('should set complex values', function () {
        const s = new Store({});
        s.set('a.b.c', 33);
        assert.equal(s.get('a.b.c'), 33);
        s.set('a.b', {c:12, d: 20});
        assert.equal(s.get('a.b.c'), 12);
        assert.equal(s.get('a.b.d'), 20);
        s.set('a.b', null);
        assert.equal(s.get('a.b.d'), void 0);

    })
});