import '../../cmp/field/LabeledField.jsx';
import Button from '../../cmp/button/Button.jsx';
import Logo from '../../../svg/logo_vkusvill.svg';
import './loginPage.scss';
/*import {AsyncAjax} from '/core/Ajax.jsx';
import {API} from '/dict/Consts.jsx';*/
import Arr  from '../../../svg/arr.svg';
import ArrB  from '../../../svg/arr-back.svg';

const {AND, OR, IF} = Store;
export default D.declare('view.page.Login', () => {
    const loginStore = new Store({
        phone: '7123456789',
        code: '',
        codeValid: false,
        active: 'enterPhone',
        phoneValid: false,
        phoneChecking: false,
        incorrectPhone: false,
        authHelp: false,
        codeError: false
    });
    loginStore.sub('phone', function (phone) {
       loginStore.set('phoneValid', phone.length === 11);
    });
    loginStore.sub('code', function (code) {
        loginStore.set('codeValid', (code+'').length === 6);
    });
    const checkPhone = async function() {
      loginStore.set('phoneChecking', true);
      try{
        const result = await AsyncAjax.post( API.ENDPOINTS.CHECK_CODE, data );
        console.log(result)
      }catch( e ){

      }
      setTimeout(function() {
        loginStore.set('phoneChecking', false);
        loginStore.set('active', 'enterCode');
      }, 2000)
    };
    const checkCode = function () {
        loginStore.set('codeChecking', true);
        setTimeout(function() {
            loginStore.set('codeChecking', false);
            loginStore.set('codeError', true);
        }, 2000)
    };


    return <div className={"login-page"}>
        <div class="login-page__big-logo">
            <Logo width="660" height="300"/>
        </div>
        <h1 class="login-page__title">Добро пожаловать в&nbsp;развивающую платформу Вкусвилл!</h1>
        <Switch store={loginStore} key='authHelp'>
            <Switch.Item id={false}>
                <form action="#" method="post" className="authorization-form">
                    <Switch store={loginStore} key='active'>
                        <Switch.Item id='enterPhone'>
                            <view.cmp.field.LabeledField required label={'Введите номер телефона, чтобы продолжить.'} placeholder={'Ваш телефон'} type={'tel'} bind={loginStore.bind('phone')}/>
                            <Button
                                class={"button button--primary authorization-form__button"}
                                onclick={checkPhone}
                                disabled={OR(
                                    loginStore.valFalse('phoneValid'),
                                    loginStore.valTrue('phoneChecking')
                                )}
                            ><span>Далее</span><Arr width="17" height="11"/></Button>
                        </Switch.Item>
                        <Switch.Item id='enterCode'>
                            <button onClick={() => loginStore.set('active', 'enterPhone')}>Взат</button>,
                            <view.cmp.field.LabeledField
                              required
                              label={'Введите код из СМС'}
                              placeholder={'Код'}
                              type={'number'}
                              bind={loginStore.bind('code')}
                              invalid={loginStore.valTrue('codeError')}
                            >
                                <IF condition={loginStore.valTrue('codeError')}>
                                    <span className={"labeled-field__error-message"}>Некорректный код. Попробуйте еще раз</span>
                                </IF>
                            </view.cmp.field.LabeledField>

                            <Button
                                class={"button button--primary authorization-form__button"}
                                onclick={checkCode}
                                disabled={OR(
                                    loginStore.valFalse('codeValid'),
                                    loginStore.valTrue('codeChecking')
                                )}><span>Далее</span><Arr width="17" height="11"/></Button>
                        </Switch.Item>
                    </Switch>
                    <Button onClick={() => loginStore.set('authHelp', true)}>Проблемы с авторизацией?</Button>
                </form>
            </Switch.Item>
            <Switch.Item id={true}>
                <Button onClick={() => loginStore.set('authHelp', false)}><ArrB width="17" height="11"/><span>Вернуться к авторизации</span></Button>
            </Switch.Item>
        </Switch>
    </div>
})
