import Button from "../../page/account/Account";
import Eye from '/svg/eye.svg';

const Card = D.declare('view.cmp.Card', (cfg) => {
    return <div className={D.cls('card card--'+(cfg.disabled?'disabled':cfg.type))}>
        <div className="card__image">
            <img src="/uploads/images/card_product3.jpg" alt=""/>
        </div>
        <h3 className="card__title">{cfg.title}</h3>
        <div className="card__footer">
            {cfg.disabled ? null:
                cfg.seen ?
                    <div className="card__note">
                        <span>Просмотрена</span>
                        <Eye width="20" height="13"/>
                    </div>
                    :
                    <Button class={"button card__button"} onclick={cfg.onclick}>
                        <span>Изучить</span>
                    </Button>
            }
        </div>
    </div>
})

export default Card;
export {Card};
