import './accountPage.scss';
import AccountBlock from '../../block/account/Account.jsx';
import {AsyncAuthAjax} from "../../../controller/Ajax";
import {API} from "../../../dict/Consts";
import Card from "../../cmp/card/Card";
import CardSlider from "../../cmp/cardSlider/CardSlider";

const Account = D.declare('view.page.Account', () => {



    return <div class="account-page">
        <h1 class="readers-only">Страница личного кабинета сотрудника</h1>
        <div class="account-page__wrapper">
            <div class="account-page__menu">
                <div class="account-page__menu-inner">
                    <AccountBlock />
                </div>
            </div>
            <div class="account-page__content">
                <div class="account-page__content-inner">
                    <div class="account-page__cards">
                        <h2 class="account-page__title">Новые карточки для вашей должности:</h2>
                        <CardSlider
                          items={_=> store.sub(
                            [
                                'loaded.cards',
                                'navigation.current',
                                tmpStore.bind('loaded')
                            ],
                            (loadedCards, page, loaded,w)=>{

                                      if(loadedCards && page === 'Account' && loaded)
                                          _(cards
                                            .getArray()
                                            .filter(card=>card.seen === false)
                                            .sort((a,b)=>a.id-b.id), w+(w<1024?0:320+30*2+30*2)
                                          )
                                  })}
                        />
                        <div className="no-cards">
                            <div className="no-cards__text">
                                
                            </div>
                            <div className="no-cards__image">
                                <img src="uploads/images/assistant-nocards.svg" alt=""/>
                            </div>
                        </div>
                       {/* {(()=> {
                            let c = <div/>;
                            (async () => {
                                const result = await AsyncAuthAjax.get(API.ENDPOINTS.GET_USER_NEW_CARDS());

                                D.appendChild(c, result.map((item, n) =>


                                    <div class="cards-list__item">
                                        <Card
                                            type={'product,info,other'.split(',')[n % 3]}
                                            disabled={n % 5 === 0}
                                            seen={n % 4 === 0}
                                            title={item.name}
                                            image={item.image}
                                        />
                                    </div>
                                ));

                            })();


                            return c

                        })()}*/}
                        {/*
                        <div class="cards-list__item">
                            <div class="card card--info">
                                <div class="card__image">
                                    <img src="/uploads/images/card_product1.jpg" alt=""/>
                                </div>
                                <h3 class="card__title">Название карточки</h3>
                                <div class="card__footer">
                                    <Button class={"button card__button"}>
                                        <span>Изучить</span>
                                    </Button>
                                </div>
                            </div>
                        </div>
                        <div class="cards-list__item">
                            <div class="card card--product">
                                <div class="card__image">
                                    <img src="/uploads/images/card_product2.jpg" alt=""/>
                                </div>
                                <h3 class="card__title">Название карточки</h3>
                                <div class="card__footer">
                                    <Button class={"button card__button"}>
                                        <span>Изучить</span>
                                    </Button>
                                </div>
                            </div>
                        </div>
                        <div class="cards-list__item">
                            <div class="card card--other">
                                <div class="card__image">
                                    <img src="/uploads/images/card_product3.jpg" alt=""/>
                                </div>
                                <h3 class="card__title">Название карточки</h3>
                                <div class="card__footer">
                                    <Button class={"button card__button"}>
                                        <span>Изучить</span>
                                    </Button>
                                </div>
                            </div>
                        </div>
                        <div class="cards-list__item">
                            <div class="card card--seen">
                                <div class="card__image">
                                    <img src="/uploads/images/card_product4.jpg" alt=""/>
                                </div>
                                <h3 class="card__title">Название карточки</h3>
                                <div class="card__footer">
                                    <div class="card__note">
                                        <span>Просмотрена</span>
                                        <Eye width="20" height="13" />
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="cards-list__item">
                            <div class="card card--disabled">
                                <div class="card__image">
                                    <img src="/uploads/images/card-disabled.png" alt=""/>
                                </div>
                                <h3 class="card__title">Карточек нет</h3>
                                <div class="card__footer">
                                </div>
                            </div>
                        </div>*/}
                    </div>
                </div>
            </div>
        </div>
    </div>
});

export default Account;
export {Account};
