view.page.Components = function(){
  let componentTable;
  this.dom = div( { cls: 'content-component' },
    div({cls: 'product-filter__area title-gradient'},
      div({cls: 'product-filter'},
        div({cls: 'product-filter__title'},'Фильтр'),
        D.input({
          attr: {
            value: (update)=>store.sub('componentFilterText', (val)=>update(val))},

          cls: 'product-filter__input',
          on: {input: (e)=>store.set('componentFilterText', e.target.value)}})
      )
    ),
    componentTable = new view.cmp.Table( {
      sorters: [ { id: 'title', type: String } ],
      sort: [ { name: 'asc' } ],
      filterFn: function( text, me ){
        return !text || textFilterMatched( this.name, text )
      },
      afterFilter: ( items ) => store.set( 'componentFilteredCount', items.length ),
      itemTpl: ( item, me, bonus ) => {
        const dom = div( { cls: 'table-item table-item__component' },
          span( {
            cls: 'component-title',
            on: { click: tableAction },
            attr: { 'data-action': 'toggle:' + item.id }

          }, me.highlight( item.name ), ' ≡' )
        );
        return dom;
      },
      items: dP.componentsList
    } )
  );

  const tableAction = componentTable.getActionDelegate();

  store.sub([
    'componentFilterText'
  ], function(text) {
    componentTable.filter(text.trim().toLowerCase());
    componentTable.updateChildren();
  });

};