import './Header.scss';
import Button from "/view/cmp/button/Button.jsx";
import Logo  from '/svg/logo.svg';
import User from "/svg/user.svg";
import Logout from "/svg/logout.svg";

const {IF, NOT} = Store;
export default D.declare('view.block.Header', () => {
    return <header class={D.cls(
        "page-header", {
            "page-header--inner": (NOT(store.valEqual( 'navigation.current', 'login')))
        })}   >
        {
            [
                'login',
                'main','fields'
            ].map(name=>
                <button class="button-temp" type={'button'} onClick={() => store.set('navigation.current', name)}>{name}</button>
            )
        }
        <IF condition={NOT(store.valEqual( 'navigation.current', 'login'))}>
            <div className="page-header__wrapper">
                <a href="#" class="page-header__logo">
                    <Logo width="116" height="41"/>
                </a>
                <div class="page-header__user-block">
                    <Button class={"button page-header__profile-link"}
                            type={"button"}
                            >
                        <User width="32" height="32"/><span>Иванов Иван</span>
                    </Button>
                    <Button class={"button page-header__logout-link"}
                            type={"button"}
                    >
                        <Logout width="18" height="18"/><span>Выйти</span>
                    </Button>
                </div>
            </div>
        </IF>

    </header>
});
