import '../../cmp/field/LabeledField.jsx';
import Button from '../../cmp/button/Button.jsx';
import Logo from '../../../svg/logo_vkusvill.svg';
import './loginPage.scss';
import {AsyncAjax} from '/core/Ajax.jsx';
import {API} from '/dict/Consts.jsx';

const {AND, OR} = Store;
export default D.declare('view.page.Login', () => {
    const loginStore = new Store( {
      phone: '7',
      code: '',
      active: 'enterPhone',
      phoneValid: false,
      phoneChecking: false,
      incorrectPhone: false
    });
    loginStore.sub('phone', function (phone) {
       loginStore.set('phoneValid', phone.length === 11);
    });

    const checkPhone = async function() {
      loginStore.set('phoneChecking', true);
      try{
        const result = await AsyncAjax.post( API.ENDPOINTS.CHECK_CODE, data );
        console.log(result)
      }catch( e ){

      }
      setTimeout(function() {
        loginStore.set('phoneChecking', false);
        loginStore.set('active', 'enterCode');
      }, 2000)
    };

    return <div className={"login-page"}>
        <div class="login-page__big-logo">
            <Logo width="660" height="300"/>
        </div>
        <h1 class="login-page__title">Добро пожаловать в&nbsp;развивающую платформу Вкусвилл!</h1>
        <form action="#" method="post" className="authorization-form">
            <Switch store={loginStore} key='active'>
                <Switch.Item id='enterPhone'>
                    <view.cmp.field.LabeledField label={'Введите номер телефона, чтобы продолжить.'} placeholder={'Ваш телефон'} type={'tel'} bind={loginStore.bind('phone')}/>
                    <Button
                        class={"button button--primary authorization-form__button"}
                        onclick={checkPhone}
                        disabled={OR(
                            loginStore.valFalse('phoneValid'),
                            loginStore.valTrue('phoneChecking')
                        )}
                    >Ну да</Button>
                </Switch.Item>
                <Switch.Item id='enterCode'>
                    <button onClick={() => loginStore.set('active', 'enterPhone')}>Взат</button>,
                    <view.cmp.field.LabeledField label={'Code'}/>
                </Switch.Item>
            </Switch>
        </form>
    </div>
})
