view.cmp.Table = function(cfg){
  Object.assign(this, cfg);
  const children = this.childrenEl = D.div({
    cls: 'cmp-table__children'
  });

  this.dom = D.div({
    cls: D.cls('cmp-table', cfg.cls)
  }, children);

  this.currentSlice = [];
  this.childrenEls = [];
  setTimeout(()=>this.updateChildren(),0);
};
view.cmp.Table.prototype = {
  currentSlice: [],
  childrenEls: [],
  childrenEl: null,
  filterText: '',
  filterFn: () => true,
  afterFilter: ()=>true,
  filter: function(text) {
    this.filterText = text;
    this.filterRegExp = new RegExp(text.replace(/[\[\]\(\)\?\*\.\+]/g,'').replace(/\s+/g,'|'), 'ig')
  },
  fetch: function() {
    const field = Object.keys(this.sort[0])[0]
    this.currentSlice = this.items
      .filter(item=>this.filterFn.call(item, this.filterText, this))
      .sort((a,b)=>a[field] > b.field ? 1 : a[field] < b.field ? -1 : 0)
      .map(data=>({data, dom: null}));

    this.afterFilter(this.getSelected());
  },
  updateChildren: function() {
    this.fetch();
    D.removeChildren(this.childrenEl);
    this.currentSlice.forEach((item) => {
      D.appendChild(this.childrenEl, item.dom = this.itemTpl(item.data, this, item));
    })
  },
  updateChild: function(item) {
    if(item.dom){
      const dom = this.itemTpl(item.data, this, item);
      item.dom.parentNode.replaceChild(dom, item.dom);
      item.dom = dom;
    }
  },
  updateChildByData: function(data) {
    const match = this.currentSlice.filter(i=>i.data===data),
          item = match[0];

    if(!item)
      return;

    if(item.dom){
      const dom = this.itemTpl(item.data, this, item);
      item.dom.parentNode.replaceChild(dom, item.dom);
      item.dom = dom;
    }
  },
  getSelected: function() {
    return this.currentSlice.filter(i=>!i.hidden).map(i=>i.data)
  },
  highlight: function(text) {
    if(!this.filterText)
      return text;
    const txts = [];
    ;

    return D.join(text.replace(this.filterRegExp, function(match) {
      txts.push(match);
      return '|||||'
    }).split('|||||'), (i)=>D.span({cls: 'highlighted'}, txts[i]))
  },
  getActionDelegate: function() {
    var me = this;
    return function(e) {
      const [type, val] = this.getAttribute('data-action').split(':');
      const match = me.currentSlice.filter(({data})=>data.id+'' === val+'');
      if(type === 'hide'){

        if(match.length){
          match[0].hidden = true;
          me.updateChild(match[0])
          me.afterFilter(me.getSelected());
        }
      }
      if(type === 'toggle'){
        if(match.length){
          match[0].full = !match[0].full;
          me.updateChild(match[0])
        }
      }
      e.stopPropagation();
    }
  },

};