import './productCard.scss';
import Info from "/svg/info.svg";
import Format from "../format/Format";
const {IF} = Store;
const ProductCard = D.declare('view.cmp.ProductCard', ({item}) => {
    return <div class="product-card">
        <div className="product-card__image">
            <img src={item.image} alt=""/>
        </div>
        <div className="product-card__list">
            <IF condition={item.items && item.items.length}>
                <h2>Ингредиенты</h2>
                <ul>
                    {
                        item.items.map(
                          subItem=>
                            <li>{subItem.name}</li>)
                    }

                </ul>
            </IF>
        </div>
        <div className="product-card__text">
            <Info width="30" height="30"/>
            <p><b>Важно знать.</b></p>
            <Format>{item.text}</Format>
        </div>
    </div>
})

export default ProductCard;
export {ProductCard};
