const Action = function(fn) {
  this.fn = fn;
  this.execute = this.execute.bind(this);
};
Action.prototype = {
  execute: function() {
    this.fn.apply(this, arguments);
  }
};
const ACTION = {
  NAVIGATE: new Action((where, data)=>{
    store.set({
      'navigation.current': where,
      'navigation.data': data || {}
    });
  }),
  CARD: {
    LEARN_MORE: new Action((item)=>{
      ACTION.NAVIGATE.execute('InfoPage', {id: item.id, category: item.category_id});
    })
  },
  YOU_CAN: {
    START_TEST_TESTING: new Action(()=>{
      console.log('START_TEST_TESTING');
      ACTION.NAVIGATE.execute('ChooseType');
    })
  },
  TEST: {
    DEMO: {
      GOTO_FINAL_WELCOME: new Action(()=>{
        ACTION.NAVIGATE.execute('WelcomeDemoFinal');
      }),
      GOTO_FINAL_LAST_NOTIFICATION: new Action(()=>{
        ACTION.NAVIGATE.execute('WelcomeDemoFinalLastNotification');
      }),
      GOTO_FINAL_TEST: new Action(()=>{
        ACTION.NAVIGATE.execute('WelcomeDemoFinalLastNotification');
      }),
      LIMITLESS: new Action(()=>{

      })
    }
  },

  Action
};

export default ACTION
export {ACTION};
typeof window !== 'undefined' && (window.ACTION = ACTION);
