import { TNetInput } from 'tfjs-image-recognition-base';
import { TinyYolov2Types } from 'tfjs-tiny-yolov2';
import { TinyYolov2 } from '.';
import { FullFaceDescription } from './classes/FullFaceDescription';
import { FaceDetectionNet } from './faceDetectionNet/FaceDetectionNet';
import { FaceLandmark68Net } from './faceLandmarkNet/FaceLandmark68Net';
import { FaceRecognitionNet } from './faceRecognitionNet/FaceRecognitionNet';
import { Mtcnn } from './mtcnn/Mtcnn';
import { MtcnnForwardParams } from './mtcnn/types';
export declare function allFacesSsdMobilenetv1Factory(ssdMobilenetv1: FaceDetectionNet, landmarkNet: FaceLandmark68Net, recognitionNet: FaceRecognitionNet): (input: TNetInput, minConfidence?: number, useBatchProcessing?: boolean) => Promise<FullFaceDescription[]>;
export declare function allFacesTinyYolov2Factory(tinyYolov2: TinyYolov2, landmarkNet: FaceLandmark68Net, recognitionNet: FaceRecognitionNet): (input: TNetInput, forwardParams?: TinyYolov2Types.TinyYolov2ForwardParams, useBatchProcessing?: boolean) => Promise<FullFaceDescription[]>;
export declare function allFacesMtcnnFactory(mtcnn: Mtcnn, recognitionNet: FaceRecognitionNet): (input: TNetInput, mtcnnForwardParams?: MtcnnForwardParams, useBatchProcessing?: boolean) => Promise<FullFaceDescription[]>;
