import * as tf from '@tensorflow/tfjs-core';
import { FaceDetection } from './FaceDetection';
import { FaceDetectionNet } from './faceDetectionNet/FaceDetectionNet';
import { FaceLandmarkNet } from './faceLandmarkNet/FaceLandmarkNet';
import { FaceLandmarks68 } from './faceLandmarkNet/FaceLandmarks68';
import { FaceRecognitionNet } from './faceRecognitionNet/FaceRecognitionNet';
import { FullFaceDescription } from './FullFaceDescription';
import { Mtcnn } from './mtcnn/Mtcnn';
import { MtcnnForwardParams, MtcnnResult } from './mtcnn/types';
import { NetInput } from './NetInput';
import { TinyYolov2 } from './tinyYolov2/TinyYolov2';
import { TinyYolov2ForwardParams } from './tinyYolov2/types';
import { TNetInput } from './types';
export declare const detectionNet: FaceDetectionNet;
export declare const landmarkNet: FaceLandmarkNet;
export declare const recognitionNet: FaceRecognitionNet;
export declare const nets: {
    ssdMobilenet: FaceDetectionNet;
    faceLandmark68Net: FaceLandmarkNet;
    faceRecognitionNet: FaceRecognitionNet;
    mtcnn: Mtcnn;
    tinyYolov2: TinyYolov2;
};
export declare function loadFaceDetectionModel(url: string): Promise<void>;
export declare function loadFaceLandmarkModel(url: string): Promise<void>;
export declare function loadFaceRecognitionModel(url: string): Promise<void>;
export declare function loadMtcnnModel(url: string): Promise<void>;
export declare function loadTinyYolov2Model(url: string): Promise<void>;
export declare function loadModels(url: string): Promise<[void, void, void, void, void]>;
export declare function locateFaces(input: TNetInput, minConfidence?: number, maxResults?: number): Promise<FaceDetection[]>;
export declare function detectLandmarks(input: TNetInput): Promise<FaceLandmarks68 | FaceLandmarks68[]>;
export declare function computeFaceDescriptor(input: TNetInput): Promise<Float32Array | Float32Array[]>;
export declare function mtcnn(input: TNetInput, forwardParams: MtcnnForwardParams): Promise<MtcnnResult[]>;
export declare function tinyYolov2(input: TNetInput, forwardParams: TinyYolov2ForwardParams): Promise<FaceDetection[]>;
export declare type allFacesFunction = (input: tf.Tensor | NetInput | TNetInput, minConfidence?: number, useBatchProcessing?: boolean) => Promise<FullFaceDescription[]>;
export declare const allFaces: allFacesFunction;
export declare type allFacesMtcnnFunction = (input: tf.Tensor | NetInput | TNetInput, mtcnnForwardParams?: MtcnnForwardParams, useBatchProcessing?: boolean) => Promise<FullFaceDescription[]>;
export declare const allFacesMtcnn: allFacesMtcnnFunction;
