Screen.Main = function() {
	const showJoinForm = new Store.Value.Boolean(false);
	const dom = D.div({cls: 'main-background'},
		D.h('img', {src: 'amazon-logo.svg', cls: 'logo'}),
		D.div({cls: 'sub-content'},
			D.div({cls: ['main-connection-type-select', {hidden: showJoinForm}]},
				D.div({cls: 'h1'}, 'Conferences made easy'),
				D.div({cls: 'p'},
					'Use VR calls with remote guests to immerse in conversation and',
					D.h('br'),
					'feel more involved'
				),

				D.div({cls: 'main-buttons'},
					D.h('button', {cls: 'button primary', onclick: ()=>Screen.show('Conference', true)}, 'Create New Session'),
					D.h('button', {cls: 'button primary', onclick: ()=> showJoinForm.set(true)}, 'Connect to Session'),
				)
			),
			D.div({cls: ['join-screen', {hidden: Store.NOT(showJoinForm)}]},

				D.div({cls: 'h1'}, 'Enter Session ID'),
				D.div({cls: 'p'},
					Input({placeholder: 'Session ID'}, 'conference_id')
				),

				D.div({cls: 'main-buttons'},
					D.h('button', {cls: 'button primary', onclick: ()=>Screen.show('Conference', true)}, 'Connect to Session'),
					D.h('button', {cls: 'button secondary', onclick: ()=> showJoinForm.set(false)}, 'Go Back'),
				)

			)

		)
	);
	return dom;
};

Screen.Main.beforeShow = function() {
	store.set({
		conference_id: getConferenceID()
	});
};