AddCss('/view/tableComponent.css');

var UserIcon = function(percent, inverse) {
	return D.div({cls: ['table-component--guest-row--guest__user-icon', {inverse}],
			style: {
				transform: 'rotate('+ ((32*percent-16)*(inverse?-1:1)+(inverse?180:0)).toFixed(2) +'deg)'
			}},
		D.div({
			cls: 'table-component--guest-row--guest__user-icon--obod'
		},

			D.div({cls: 'in-obod1'}),
			D.div({cls: 'in-obod2'}),
		),
		D.div({cls: 'table-component--guest-row--guest__user-icon--circle'})
	);
};

var TableComponent = function(cfg) {
	var k = 1;
	var RoleGuest = function(role, position, percent, inverse) {

		var selected = new Store.Value.Boolean(false);
		var disabled = new Store.Value.Boolean(false);

		store.sub([cfg.role, cfg.guestPosition], function(r, p) {
			selected.set((role.realValue === r || role.value === r) && position.value === p);
		});

		var guest = [
				D.div({cls: 'table-component--guest-row--guest__label'}, role.text+' '+position.text),
				UserIcon(percent, inverse)
			];

		return D.div({
				cls: [
					'table-component--guest-row--guest table-component--guest-row--guest-'+(k++),
					{
						'table-component--guest-row--guest__selected': selected,
						'table-component--guest-row--guest__disabled': disabled,
					}
				],
				style: {left: position.left},
				onclick: function() {
					if(disabled.get())
						return;
					cfg.role.set(role.value);
					cfg.guestPosition.set(position.value);
				}
			},
			guest[inverse?'reverse':'slice']()
		);
	};

	var RoleRow = function(role, positions, inverse) {


		return D.div({cls: 'table-component--guest-row'},
			positions.map(function(position, i) {
				var count = positions.length;
				var percent = count < 2 ? 0.5 : i/(count-1);
				return RoleGuest(role, position, percent, inverse)
			})
		);
	};

  var tableComponentHeadlineText = store.get('tableComponentHeadlineText');
	var tableComponentHeadline = D.div({cls: 'table-component-headline'}, tableComponentHeadlineText);

	var roles = store.get(cfg.roles);
	var guestPositions = store.get(cfg.guestPositions);

	var dom = D.div({cls: 'table-component'},
      tableComponentHeadline,
			RoleRow(roles[1], guestPositions, false),
			D.div({cls: 'table-component--table'}),
			RoleRow(roles[0], guestPositions, true)
		)
	return dom;
}
